#include "mbed.h"
//16.04.2020 23:19
//Программа для пошагового чтения байтов из порта (файла) и разделения потока байтов на подстроки в реальном времени. Разделитель - запятая.
//Строка сообщения должна заканчиваться только одним символом /r  или  /n (обнаружение признака окончания сообщения можно сделать любым)
//Программа нормально разбивает принимаемую строку на подстроки (до 20) в количестве равном количеству запятых, плюс последняя подстрока без запятой
//$,1500,2001,1001 - для примера здесь передаются:$ - служебный символ, 1500 - уставка давления, 2001 - уставка максимального давления, 1001 - уставка минимального давления

AnalogIn analog_value(A0);                           //подключение аналогового входа A0
DigitalOut led(LED1);
DigitalOut digitalWrite4(PB_5);    // initialize digital pin 4 as an output (high pressure air bulb charge).
DigitalOut digitalWrite7(PA_8);    // initialize digital pin 7 as an output. (high pressure air bulb discharge
RawSerial pc(USBTX, USBRX, 115200);
EventQueue *queue = mbed_event_queue();                                         //инициализация очереди событий RTOS mbed5

#define maxnstr 20                                                              // maximum nbr of params(sybstrings) used to hold the data fields
#define maxnsym 20                                                              // maximum nbr of symbols
char comand[maxnstr][maxnsym]={""};                                             // 
int nstr=0;                                                                     //номер строки 

int pressure=0;                                      //давление (аналоговый вход)
int pressure_set=0;                                  //уставка давления 
int pressure_set_max=0;                              //уставка максимальног давления 
int pressure_set_min=0;                              //уставка минимального давления 
int value=1000;                   //set "pressure" 50
int delta_value=25;              //set delta pressure
int counter_cycle1=0;
int counter_cycle2=0;

int valve1=0;   // state valve of  charge:  0 - close, 1 - open
int valve2=0;   //state valve of  discharge:  0 - close, 1 - open

//______________________________________________________________________________
void onDataReceived();                                                          // callback
//______________________________________________________________________________
void read_serial() {
    char message[maxnstr][maxnsym]={""};                                        //обнуление строк (локального двумерного массива символов фиксированного размера)
    int zap=0;                                                                  // счетчик запятых                                                
    char chr;                                                                   //байтовый символ полученный из порта (или файла)
    nstr=0;                                                                     //обнуление счетчика строк (на самом деле счетчика запятых в сообщении)
rs1:
    int string_possition=0;                                                     //обнуляем номер символа (в строке) в массиве входящей строки сообщения
    do{ chr = pc.getc();                                                        //вынимаем символ из буфера последовательного порта
        if (chr == ',')                                            //запятая в нашей системе сообщений это признак окончания подстроки
        {zap++;
         message[nstr][string_possition] ='\0';                    //дополняем подстроку символом окончания строки
         nstr++;                                                   //стетчик строк увеличиваем на единицу
         goto rs1; }                                               //выходим в начало цикла для поиска следующей подстроки
        if (chr == '\n' || chr == '\r'){message[nstr][string_possition] ='\0';break;} //если сообщение кончилось, то вставка окончания строки и выход из цикла  
        message[nstr][string_possition] = chr;                                        //складываем символы в подстроку
        string_possition++;                                                     //номер позиции символа увеличиваем на единицу
       }while (1); 
   // pc.printf("caught message_nstr is : %s\r\n", message[nstr]);                //последняя подстрока пойманного сообщения
   // pc.printf("****Detect number of _,_ ****=%d\r\n",zap);                                //количество приянтых запятых
    for (int i=0; i<=nstr; i++) {strcpy(comand[i],message[i]);}                  //копирование строк в глобальный массив , размеры массивов должны совпадать!
    for (int i=0; i<=nstr; i++) {pc.printf("Caught comand[%d] is : %s\r\n",i,comand[i]);}     //печать подстрок пойманного сообщения
    pressure_set=atoi(comand[1]);                                // перевод из строчного массива (вторая подстрока сообщения) в целое число (уставка давления) 
    pc.printf("pressure_set=%d\r\n",pressure_set);
    pressure_set_max=atoi(comand[2]);                            // перевод из строчного массива (третья подстрока сообщения) в целое число (уставка макс. давления) 
    pc.printf("pressure_set_max=%d\r\n",pressure_set_max);
    pressure_set_min=atoi(comand[3]);                            // перевод из строчного массива (четвёртая подстрока сообщения) в целое число (уставка мин. давления) 
    pc.printf("pressure_set_min=%d\r\n",pressure_set_min);
    
    pc.attach(&onDataReceived, Serial::RxIrq);                                  // reattach interrupt - переподключение прерывания перед выходом из функции
}
//______________________________________________________________________________
void onDataReceived() {
    pc.attach(NULL, Serial::RxIrq);                                             // detach interrupt
    queue->call(read_serial);                                                   // process in a non ISR context - переход к функции приема строки в статусе отключенного прерывания (учим указатели!)
}
//*****************************************************************************
int main() {
    pc.attach(&onDataReceived, Serial::RxIrq);                                  //подключение прерывания и имя функции обработчика прерывания по входящему символу в serial порту
    float raw_value ;
    int sensor_value ;
    printf("Start \r\n");
    while (1) {
       
/*--------------regulator begin---*/
  raw_value  = analog_value.read();                                           // Чтение аналогового входа (0.0 to 1.0 = full ADC диапазон)
  sensor_value  = raw_value  * 3300;                                          // преобразование в напряжение 0-3300 mV 
  if (sensor_value>value+delta_value)
  {
   digitalWrite7=1; valve2=1;
   digitalWrite4=0; valve1=0;
  } else  if (sensor_value<value-delta_value)
  {
   digitalWrite4=1; valve1=1;
   digitalWrite7=0; valve2=0; 
  } else 
  {
   digitalWrite4=0; valve1=0;
   digitalWrite7=0; valve2=0; 
  }

/*--------------regulator end-----*/
 pc.printf("$%d %d %d %d;", valve1*100-110, valve2*100-220, value, sensor_value );       
        
        ThisThread::sleep_for(20);                                             // (mc) правильный оператор задержки для mbed5
        led = !led;
    }
}