#include "mbed.h"
//10.04.2020 00:07
//Программа для пошагового чтения байтов из порта (файла) и разделения потока байтов на подстроки в реальном времени. Разделитель - запятая.
//Строка сообщения должна заканчиваться только одним символом /r  или  /n
//Программа нормально разбивает принимаемую строку на подстроки в количестве равном количеству запятых, плюс последняя подстрока без запятой
//$COMAND,123519,A,4807.038,N,01131.000,E,022.4,084.4,230394,003.1,W*6A   - здесь W*6A  будет нормапльно принята
DigitalOut led(LED1);
RawSerial pc(USBTX, USBRX);
EventQueue *queue = mbed_event_queue();                                         //инициализация очереди событий RTOS mbed5

#define maxnstr 20                                                              // maximum nbr of params(sybstrings) used to hold the data fields
#define maxnsym 20                                                              // maximum nbr of symbols
char comand[maxnstr][maxnsym]={""};                                             // 
int nstr=0;                                                                     //номер строки 

void onDataReceived();                                                          // callback

void read_serial() {
    char message[maxnstr][maxnsym]={""};                                        //обнуление строк (локального двумерного массива символов фиксированного размера)
    int zap=0;                                                                  // счетчик запятых                                                
    char chr;                                                                   //байтовый символ полученный из порта (или файла)
    nstr=0;                                                                     //обнуление счетчика строк (на самом деле счетчика запятых в сообщении)
rs1:
    int string_possition=0;                                                     //номер символа (в строке) в массиве входящей строки сообщения
    do{ chr = pc.getc();                                                        //вынимаем символ из буфера последовательного порта
        if (chr == ',')
        {
         zap++;
         message[nstr][string_possition] ='\0';
         nstr++;
         goto rs1;
         }
        if (chr == '\n' || chr == '\r'){message[nstr][string_possition] ='\0';break;} //если сообщение кончилось, то вставка окончания строки и выход из цикла  
        message[nstr][string_possition] = chr;                                        //складываем символы в строку
        string_possition++;                                                     //номер позиции символа увеличиваем на единицу
       }while (1); 
    pc.printf("caught message_nstr is : %s\r\n", message[nstr]);                //пойманное сообщение
    pc.printf("****Detect _,_ ****=%d\r\n",zap);
   for (int i=0; i<=nstr; i++) {strcpy(comand[i],message[i]);}                  //копирование строк в глобальный массив , размеры массивов должны совпадать!
   
    pc.attach(&onDataReceived, Serial::RxIrq);                                  // reattach interrupt - переподключение прерывания перед выходом из функции
}

void onDataReceived() {
    pc.attach(NULL, Serial::RxIrq);                                             // detach interrupt
    queue->call(read_serial);                                                   // process in a non ISR context - переход к функции приема строки в статусе отключенного прерывания (учим указатели!)
}

int main() {
    pc.attach(&onDataReceived, Serial::RxIrq);                                  //подключение прерывания и имя функции обработчика прерывания по входящему символу в serial порту
    while (1) {
        for (int i=0; i<=nstr; i++) {pc.printf("main cycle - comand_nstr is : %s\r\n", comand[i]);}     //печать подстрок пойманного сообщения
        ThisThread::sleep_for(2000);                                             // (mc) правильный оператор задержки для mbed5
        led = !led;
    }
}