/*
  Hotboards_SpiLcd Library - Hello World
  
  Demonstrates the use a 16x2 LCD display.  The Hotboards_SpiLcd
  library works with all LCD displays that are compatible with the
  SP7032 driver presented on Spi Lcd board (http://www.hotboards.org).
  
  This sketch prints "Hello World!" to the LCD
  and shows the time.
  
  The circuit:
  *  BKL   -->  GND
  *  VDD   -->  3.3v
  *  GND   -->  GND
  *  SCLK  -->  PB_3
  *  SI    -->  PB_5
  *  CS    -->  PC_0
  *  RS    -->  PC_1
  *  RST   -->  PC_2
 
  Library and example ported by Diego from Hotboards and originally cretaed by
  by David A. Mellis
  library modified 5 Jul 2009
  by Limor Fried (http://www.ladyada.net)
  example added 9 Jul 2009
  by Tom Igoe
  modified 22 Nov 2010
  by Tom Igoe
  This example code is in the public domain.
 */
 
#include "mbed.h"
#include "Hotboards_SpiLcd.h"
#include "Hotboards_temp.h"
 
// new instance of serial port
Serial pc(USBTX, USBRX);
//I2C instance for the library
I2C device1( I2C_SDA, I2C_SCL ); 
// instance a sensor with address number 7 (none of the jumpers on the board is short circuted)
// and also 0.5 celsius degrees resolution
Hotboards_temp sensor( device1, Sensor_7);
 
 
// initialize the spi peripherals, setting the spi pins 
SPI device( PB_5, NC, PB_3 ); // mosi, miso, sclk
// initialize the library with the numbers of the interface pins
Hotboards_SpiLcd display( device, PC_0, PC_1, PC_2 ); //spi, cs, rs, rst
 
int main( void ) 
{
    // sensor init
  sensor.init();
  sensor.setResolution(_0p0625C);
 
    uint8_t milis = 0;
    // set the spi frequency to 5MHz
    device.frequency(5000000);
    // initialize internal lcd controller:
    display.init();
    // Print a message to the LCD.
    display.printf( "Temperatura" );
    
    while(1)
    
    {
          // read temperature in celcius degrees
         float temp = sensor.read();
        // set the cursor to column 0, line 1
        // (note: line 1 is the second row, since counting begins with 0):
        display.setCursor( 0, 1 );
        wait( 1 );
        milis++;
        // print the number of seconds since reset:
        display.printf( "Grados: %3.3f C", temp);
    }
}
 