#include "mbed.h"
#include "AccelSensor.h"

const int addr = 0x9A;              // define the I2C Address for TC74-A0
const int Afficheur_addr = 0xE2;    // define the I2C Address for 4*7seg display
const int Accel_addr = 0x3A;        // define the I2C Address for the Accelerometer

//Defines for the serial output for debug
#define Output_Temperature true
#define Output_Accel true
#define Output_Accel_debug false

//Creating the desired objetcs
I2C i2c(p9, p10);        // sda, scl
Serial pc(USBTX, USBRX); // tx, rx
Serial Damn(p28,p27);  // Used as shortcut for printing result on 7seg using printf function as it is not available in I2C
AccelSensor acc(p9,p10);  //Should be commented as it was a part of the prototype and test, we may want to use our own function
//Mainly used to calibrate and start the device

void init(void);
char get_Temperature(void);
void Display8888(void);
void Update_Accel(void);

int main()
{
    char temp;

    init();
    wait(1);           //Make sure system is fully initialized

    Display8888();     //Display initial text 8888 on the display


    while(1) {
        pc.printf("\r\n\nStart reading the temperature of TC74 on I2C\r\n");
        temp = get_Temperature();
        Update_Accel();
        
        wait(2);

    }
}
//------------------Accelerometre ---------------------------

void Update_Accel(void)
{
    //Variables
    char cmd[7];

    //Initialisation
    cmd[0] = 0x00;                     //Command :: Status

    //Read all the register for X,Y and Z forces
    i2c.write(Accel_addr, cmd, 1);    //Issue required command to perform a write of the command
    i2c.read(Accel_addr, cmd, 7);     //Read the Data from the device
#if Output_Accel_debug
    pc.printf("Values :: %d %d %d %d %d %d %d \r\n\n", cmd[0], cmd[1], cmd[2],cmd[3],cmd[4],cmd[5],cmd[6] );
#endif
    //Damn.printf("v");
    long double anglez, anglex,angley;
    bool negatif;
    //calcul angle Z
    if (cmd[5]<0x7F) {
        anglez = acos((cmd[5]/62.0))/3.1416*180;
        negatif=false;

    } else {
        cmd[5]=(cmd[5]-256)*-1;
        anglez = acos((cmd[5]/62.0))/3.1416*180;

    }

    //calcul angle Y
    if (cmd[3]<0x7F) {
        angley = asin((cmd[3]/62.0))/3.1416*180;

    } else {
        cmd[3]=(cmd[3]-256)*-1;
        angley = asin((cmd[3]/62.0))/3.1416*180;

    }
    // calcul angle X
    if (cmd[1]<0x7F) {
        anglex = asin((cmd[1]/62.0))/3.1416*180;

    } else {
        cmd[1]=(cmd[1]-256)*-1;
        anglex = asin((cmd[1]/62.0))/3.1416*180;

    }


    //if (anglez<45
    int b = anglez;
#if Output_Accel
    pc.printf("TEST: X=%f      Y=%f      Z=%f  \r\n", anglex, angley, anglez );
#endif
    if (negatif==false)
        Damn.printf("  ");
    else
        Damn.printf(" -");

    Damn.printf("%2d", b );


    //-------------------Accel status form Imported Class --------
#if Output_Accel_debug
    int result[3];
    acc.readData(result);
    pc.printf("X: %d   Y: %d    Z:    %d \r\n", result[0],result[1],result[2]);
#endif



}

void init(void)
{
    //Let's clear the I2C display

    i2c.write(Afficheur_addr,"v",1);


    acc.init();
    acc.active();
}

char get_Temperature(void)
{
    char cmd[1];
    //Méthode 1
    //Utilisation des fonctions bas niveau
    /*
        i2c.start();            // Start condition
        a = i2c.write(addr);    // Write Device Address
        b = i2c.write(0x00);    // Write READ command of TC74 (voir page 8 de la datasheet du TC74)

        i2c.start();            //Reissue start condition
        //Au lieu de faire Stop condition et Start de nouveau

        c= i2c.write(addr|1);   //Adresse du Device en mode Lecture
        temp = i2c.read(0);     //Lecture de la valeur du registre de température
        i2c.stop();             //Fermeture de la trame
    */
    //Méthode 2
    //Utilisation des fonctions haut niveau

    cmd[0] = 0x0;               //Command :: READ
    i2c.write(addr, cmd, 1);    //Issue required command to perform a write of the command
    i2c.read(addr, cmd, 1);     //Read the Data from the device

    //-----------------Print out section ----------------------
    //Display device Address and informations

    // pc.printf("Device with address 0x%x with\r\n", addr);

    //Prints out the result of Method 1
    //pc.printf("ACK1 :: %d\n\rACK2 :: %d\n\rACK3 :: %d\n\r", a,b,c); //ACK bits
    //pc.printf("Method 1 :: %d\n\r", temp);

    //Prints out the Data from Method 2
#if Output_Temperature
    pc.printf("Temperature :: %d\r\n\n", cmd[0]);
#endif

    return cmd[0];
}

/*
**  This function display '8888' on the Hex Display using I2C transactions
**  For prototyping purpose, we will use the Serial protocol for transferring the data to the Hex display
*/
void Display8888(void)
{
    char cmd[2];
    //--------------Afficheur LCD ------------------------------

    cmd[0] = 0x7b;      //Segment 1
    cmd[1] = 0x7f;

    i2c.write(Afficheur_addr,cmd,2);

    wait(0.07);

    cmd[0] = 0x7c;      //Segment 2
    cmd[1] = 0x7f;

    i2c.write(Afficheur_addr,cmd,2);

    wait(0.07);

    cmd[0] = 0x7d;      //Segment 3
    cmd[1] = 0x7f;

    i2c.write(Afficheur_addr,cmd,2);

    wait(0.07);

    cmd[0] = 0x7e;      //Segment 4
    cmd[1] = 0x7f;

    i2c.write(Afficheur_addr,cmd,2);
}