#include "mbed.h"
#include "stdio.h"

#define al97_addr 0x50
#define fg_addr 0x6C

#define status 0x06

#define DATAOUT 10
#define OPCODE 2

#define w_addr 0x17
#define r_addr 0x18

I2C i2c(D14, D15);
PwmOut pwm(D3);
Serial pc (USBTX, USBRX);


int main(){
    wait(1);
    
    pwm.period(.001);
    
    int val;
    char serialBuff[128];
    char i2cWriteBuff[DATAOUT];
    char i2cReadBuff[7];
    char opcode[2];
    
    //Initialize all functions to 0
    char codeList[10] = {0x1A, 0x30, 0x35, 0x3A, 0x40, 0x42, 0x46, 0x48, 0x50, 0xA0};
    i2cWriteBuff[0] = 0x0F;
    for (int i = 1; i < DATAOUT-1; i++)
        i2cWriteBuff[i] = 0x00;
    for (int i = 0; i < 10; i++){
        opcode[0] = w_addr;
        opcode[1] = codeList[i];
        i2c.write(al97_addr, i2cWriteBuff, 8);
        i2c.write(al97_addr, opcode, 2);
        wait(0.05);
    }
    
    wait(0.5);
    
    i2cWriteBuff[0] = 0x06;
    i2cWriteBuff[1] = 0x20;
    i2cWriteBuff[2] = 0x00;
    i2c.write(fg_addr, i2cWriteBuff, 3);
    
    i2cWriteBuff[0] = 0x0C;
    i2cWriteBuff[1] = 0x00;
    i2cWriteBuff[2] = 0x80;
    i2c.write(fg_addr, i2cWriteBuff, 3);    
    
    
    for (int i = 1; i < DATAOUT-1; i++)
        i2cWriteBuff[i] = 0x00;
    //Begin main logic
    while(1){        
        pc.printf("Read or write?");
        pc.scanf("%s",serialBuff);
        
        if (strcmp(serialBuff, "w") == 0){
            i2cWriteBuff[0] = 0x0F;
            printf("Opcode: ");
            scanf("%x", &val);
            i2cWriteBuff[DATAOUT-1] = val;
            opcode[0] = w_addr;
            opcode[1] = val;
            
            
            int n;
            for (int i = 1; i < DATAOUT-1; i++){
                n = i-1;
                pc.printf("Modify DataOut%i?", n);
                pc.scanf("%s", serialBuff);
                
                if (strcmp(serialBuff, "y") == 0){
                    pc.printf("New value: ");
                    pc.scanf("%x", &val);
                    i2cWriteBuff[i] = val;
                }
                else
                    continue;
            }
            for (int i = 0; i < DATAOUT; i++)
                pc.printf("%x\n",i2cWriteBuff[i]);
            
            i2c.write(al97_addr, i2cWriteBuff, 8);
            i2c.write(al97_addr, opcode, 2);
        }
        
        else if (strcmp(serialBuff, "r") == 0){
            printf("Opcode: ");
            scanf("%x", &val);
            opcode[0] = w_addr;
            opcode[1] = val;
            i2c.write(al97_addr, opcode, 2);
            wait(0.05);
            i2c.read(al97_addr, i2cReadBuff, 7);
            
            for (int i = 0; i < 7; i++){
            
                printf("%x\n", i2cReadBuff[i]);
            
            }
        }
        
        else if (strcmp(serialBuff, "led0") == 0){
            i2cWriteBuff[0] = 0x2C;
            i2cWriteBuff[1] = 0x00;
            i2c.write(al97_addr, i2cWriteBuff, 2);
            printf("Current: ");
            scanf("%x", &val);
            i2cWriteBuff[0] = 0x2D;
            i2cWriteBuff[1] = val + 0x20;
            i2c.write(al97_addr, i2cWriteBuff, 2);
        }
        
        else if (strcmp(serialBuff, "pwm") == 0){
            float blah;
            printf("Duty cycle: ");
            scanf("%f", &blah);
            pwm.write(blah);
        }
        
        else
            continue;
    }
}
