/* usbhid.h */
/* USB HID class device */
/* Copyright (c) Phil Wright 2008 */

/* Modified by yours truly. */

#pragma once

#include "usbdevice.h"

class usbhid : public usbdevice
{
public:
    usbhid();

protected:
    virtual void deviceEventReset();
    virtual void endpointEventEP1In();
    virtual void endpointEventEP2In();    
    virtual bool requestGetDescriptor();
    virtual bool requestSetConfiguration();
};

#define JOYSTICK_UP    (1<<0)
#define JOYSTICK_DOWN  (1<<1)
#define JOYSTICK_LEFT  (1<<2)
#define JOYSTICK_RIGHT (1<<3)

class USBJoystick : public usbhid
{
public:
    USBJoystick();
    bool update(uint8_t gamepad_id, uint8_t stick, uint32_t buttons);
protected:
    virtual bool requestGetDescriptor();
};
