/* usbdc.h */
/* USB device controller */
/* Copyright (c) Phil Wright 2008 */

#pragma once

/* Endpoints */
#define EP0OUT  (0) /* Control */
#define EP0IN   (1) /* Control */
#define EP1OUT  (2)
#define EP1IN   (3)
#define EP2OUT  (4)
#define EP2IN   (5)

#include "mbed.h"

class usbdc
{
public:
    usbdc();
    void connect();
    void disconnect();
protected:
    void setAddress(unsigned char address);
    void realiseEndpoint(unsigned char endpoint, unsigned long maxPacket);
    void enableEndpointEvent(unsigned char endpoint);
    void disableEndpointEvent(unsigned char endpoint);
    void stallEndpoint(unsigned char endpoint);
    void unstallEndpoint(unsigned char endpoint);
    bool getEndpointStallState(unsigned char endpoint);
    void configureDevice();
    void unconfigureDevice();
    unsigned long endpointRead(unsigned char endpoint, unsigned char *buffer);
    void endpointWrite(unsigned char endpoint, unsigned char *buffer, unsigned long size);
    void enableEvents();
    void disableEvents();
    virtual void deviceEventReset();
    virtual void deviceEventFrame();
    virtual void endpointEventEP0Setup();
    virtual void endpointEventEP0In();
    virtual void endpointEventEP0Out();
    virtual void endpointEventEP1In();
    virtual void endpointEventEP1Out();
    virtual void endpointEventEP2In();
    virtual void endpointEventEP2Out();
private:
    void SIECommand(unsigned long command);
    void SIEWriteData(unsigned char data);
    unsigned char SIEReadData(unsigned long command);
    void setDeviceStatus(unsigned char status);
    void setEndpointStatus(unsigned char endpoint, unsigned char status);
    unsigned char getDeviceStatus();
    unsigned char selectEndpoint(unsigned char endpoint);
    unsigned char selectEndpointClearInterrupt(unsigned char endpoint);
    unsigned char clearBuffer();
    void validateBuffer();
    void usbisr();
    unsigned long endpointStallState;
    static void _usbisr();
    static usbdc *instance;
};
