#include "config.h"
#include "mbed.h"
#include "usbhid.h"

#if CONFIG_TWO_REPORTS || CONFIG_TWO_INTERFACES
BusIn buttonsL
(
    p17, p16, p15, p20, // 3 top row, bottom-left
    p19, p18, p14       // 2 bottom right, 1p
);

BusIn buttonsR
(
    p9,  p8,  p7,  p12, // 3 top row, bottom-left
    p11, p10, p6        // 2 bottom right, 2p
);

BusIn stickL(p21, p22, p23, p24);
BusIn stickR(p28, p26, p27, p29);
#endif

#if CONFIG_2ND_PAD_AS_BUTTONS
BusIn buttonsL
(
    p17, p16, p15, p20, // 3 top row, bottom-left
    p19, p18, p14       // 2 bottom right, 1p
);

BusIn buttonsR
(
    p9,  p8,  p7,  p12, // 3 top row, bottom-left
    p11, p10, p6,  p28, // 2 bottom right, 2p, pad
    p26, p27, p29       // pad, pad, pad
);

BusIn stickL(p21, p22, p23, p24);
#endif

USBJoystick joysticks; // left and right pads

int main()
{
    uint8_t stickL_old = 0;
#if CONFIG_TWO_REPORTS || CONFIG_TWO_INTERFACES
    uint8_t stickR_old = 0;
#endif
    uint32_t buttonsL_old = 0;
    uint32_t buttonsR_old = 0;

    while(1)
    {
        const uint8_t stickL_new = stickL.read();
#if CONFIG_TWO_REPORTS || CONFIG_TWO_INTERFACES
        const uint8_t stickR_new = stickR.read();
#endif
        const uint32_t buttonsL_new = buttonsL.read();
        const uint32_t buttonsR_new = buttonsR.read();

#if CONFIG_TWO_REPORTS || CONFIG_TWO_INTERFACES
        if ((stickL_old != stickL_new) || (buttonsL_old != buttonsL_new))
        {
            stickL_old = stickL_new;
            buttonsL_old = buttonsL_new;
            joysticks.update(1, stickL_old, buttonsL_old);
        }

        if ((stickR_old != stickR_new) || (buttonsR_old != buttonsR_new))
        {
            stickR_old = stickR_new;
            buttonsR_old = buttonsR_new;
            joysticks.update(2, stickR_old, buttonsR_old);
        }
#endif

#if CONFIG_2ND_PAD_AS_BUTTONS
        if ((stickL_old != stickL_new) || (buttonsL_old != buttonsL_new) || (buttonsR_old != buttonsR_new))
        {
            const uint32_t buttons = buttonsL_new | (buttonsR_new << 7);
            
            stickL_old = stickL_new;
            buttonsL_old = buttonsL_new;
            buttonsR_old = buttonsR_new;
            joysticks.update(0, stickL_old, buttons);
        }
#endif

        wait(0.016666); /* 60 Hz */
    }
}