#ifndef CRGPS_H
#define CRGPS_H

#include "mbed.h"

#define    gps_lookingForSentence   0
#define    gps_lookingForCS         1
#define    gps_lookingForLineEnd    2

#define GGA_string "GGA"
#define GSA_string "GSA"
#define GSV_string "GSV"
#define VTG_string "VTG"
#define RMC_string "RMC"


#define gps_gga_packet 1
#define gps_gsv_packet 2
#define gps_vtg_packet 3
#define gps_rmc_packet 4
#define gps_gsa_packet 5

enum gps_fixtype
{
    invalid,
    twoD,
    threeD
};

struct gps_satellite_t
{
    int satPRN;
    int elevation;
    int azimuth;
    int snr;
    bool usedForFix;
};

struct gps_fix_t
{
    float hdop;
    float pdop;
    float vdop;
    bool valid;
    gps_fixtype type;
};

struct gps_position_t
{
    double latitude;
    double longitude;
    double altitude;
};

struct gps_track_t
{
    double heading;
    double groundSpeedKnots;
    double groundSpeedKmh;
};

struct gps_time_t
{
    int hour;
    int minute;
    int second;
    int day;
    int month;
    int year;
};

class CelestialReachGPS : Serial 
{ 
    // private
    double baudwait;
    
    
    gps_satellite_t satellites[20];
    
    char gpsline[BUFSIZ];
    int gpslinePos;
    
    int state;
    int packetType;
    int checksum;
    char csA;
    char csB;
    int rxcs;
    
    
    float currentSpeed;
    float currentHeading;
    
    int tokenNum;
    
    void readLatitude(int);
    void readLongitude(int);
    int fromHex(char);
    
    void processGSV();
    void processGSA();
    void processRMC();
    void processVTG();
    void processGGA();
    
    void irq_rx();
    
    void VenusWriteData(uint8_t *data, int length, int messageId);
    
    public:
        CelestialReachGPS(PinName, PinName, int = 9600);
        
        void VenusGpsConfig();
        
        bool hasReceivedData;
        
        gps_time_t currentTime;
        gps_position_t currentPosition;
        gps_fix_t currentFix;
        gps_track_t currentTrack;
        
        int currentSatsInView;
        int currentSatsTracked;
        
        int currentFixQual;
        
        int checkfail;
        
        gps_time_t lastTime();
        gps_track_t lastTrack();
        gps_fix_t lastFix();
        gps_position_t lastPosition();
        int lastFixType();
        
        int lastSatsTracked();
        int lastSatsInView();
        
        int checksumErrors();
        
        void setBaud(int baudRate);
};
#endif