#include "mbed.h"
#include "ws2801.h"
#include "rtos.h"

#define STRIP_LEN 32
#define SERIAL_RATE 2000000

RawSerial pc(SERIAL_TX, SERIAL_RX);

ws2801 led(PA_5, PA_7, STRIP_LEN);

//input cursor
int c_len = 0;
//led buffer
int led_buffer[STRIP_LEN];
bool reading = false;
bool buffer_ready = false;

void repeat() {
    char in = pc.getc();
    
    if (in != '\n' && in != '\r') {
        reading = true;
        if ( (c_len % 3) == 0 ) {
            led_buffer[ c_len / 3 ] = (in - 48) * 0x240000;
        }
        else {
            led_buffer[ c_len / 3 ] += (in - 48) * (0x240000 >> (8 * (c_len % 3)));
        }
        
        c_len++;
    }
    else {
        buffer_ready = 1;
    }
}
 
int main() {
    pc.baud(SERIAL_RATE);
  
    pc.attach(
        repeat,
        Serial::RxIrq
    );
  
    buffer_ready = 0;
    
    while (1) {
        if (buffer_ready) {
            led.post(led_buffer);
            reading = false;
            c_len = 0;
                   buffer_ready = 0;
        }
        Thread::wait(1);
    }
}
