#include "mbed.h"
#include "Adafruit_WS2801.h"

#define LED_NUM 32
#define RED 1
#define GREEN 2
#define BLUE 4

//Init strip of 32
Adafruit_WS2801 leds( LED_NUM, SPI_MOSI, SPI_SCK, WS2801_RGB );

int main () {
    int i, color;
    
    color = 1;
    
    while (1) {
        for (i = 0; i < LED_NUM; i++){
            leds.setPixelColor(
                i,
                ( color & RED > 0 ? 4 : 0 ),
                ( color & BLUE > 0 ? 4 : 0 ),
                ( color & GREEN > 0 ? 4 : 0 )
            ); 
        }
        leds.show();
        
        color = color * 2;
        
        if ( color > GREEN ) {
            color = RED ;
        }
    }
}