#include "apa102.h"
#include "mbed.h"

#define DO_N(N, F) for( int repetier = 0; repetier < N; repetier++) { F; }

//------------------------------------------------------------------------------------------------------------
apa102::apa102(PinName CKI, PinName SDI, int STRIP_LENGTH, int reset_delay)
: _CKI(CKI), _SDI(SDI), _STRIP_LENGTH(STRIP_LENGTH), _reset_delay(reset_delay) {
    
    _level=100;
    this->clear();
    wait_us(_reset_delay);
}
//------------------------------------------------------------------------------------------------------------
void apa102::post(int *strip_colors) {
    this->preamble();

    int scaled_level = 0xE0 | (_level * 31 / 100);
    
    for(int LED_number = 0 ; LED_number < _STRIP_LENGTH ; LED_number++) {
        this->write_word(scaled_level, 8);
        this->write_word(strip_colors[LED_number], 24);
    }
    
    this->afterword();
    wait_us(_reset_delay); //Wait for 1ms to go into reset
}
//------------------------------------------------------------------------------------------------------------
void apa102::clear(void) {
    this->preamble();
    DO_N(_STRIP_LENGTH, this->write_word(0xE0000000, 32));
    this->afterword();
}
//------------------------------------------------------------------------------------------------------------
int apa102::level(int level)
{
if((level <= 100) && level)
  {
  _level = level;
  return _level;
  }
return 0;
}

//------------------------------------------------------------------------------------------------------------
int apa102::delay(uint32_t reset_delay)
{
if(reset_delay <= 0xffffffff)_reset_delay = reset_delay;
return _reset_delay;
}
//------------------------------------------------------------------------------------------------------------
inline void apa102::write_hi() {
    this->write_bit(1);
}
inline void apa102::write_lo() {
    this->write_bit(0);
}
inline void apa102::write_bit(bool bit) {
    _CKI = 0;
    _SDI = bit;
    _CKI = 1;
}
inline void apa102::write_word(uint32_t word, int bits) {
    for(char color_bit = bits - 1 ; color_bit != 255 ; color_bit--) {
        this->write_bit(
            (word & (1 << color_bit)) ? 1 : 0
        );
    }
}
inline void apa102::write_done() {
    _CKI = 0;
}
inline void apa102::preamble() {
    DO_N(32, this->write_lo());
}
inline void apa102::afterword() {
    DO_N(32, this->write_hi());
    this->write_done();
}
//---------EOF---------------EOF------------------------------------------------------------------------------