#include "mbed.h"
//#include "esc.h"
#include "Servo.h"
#include "HX711.h"
#include "rtos.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
//ESC esc1(p24);

Servo esc1(p23);
HX711 scale(p29, p30);
InterruptIn pb1(p21);
InterruptIn pb2(p22);
Timer t;
Thread thread1;
Thread thread2;

float cnt = 0.025;
float weight = 0.0;
int x = 0;


float calibration_factor = -112650.0;; //-7050 worked for my 440lb max scale setup
int averageSamples = 100;

void flip_pb1();
void flip_pb2();
void rpm_fun();
void extract_data();
void ON_OFF();

int main() {
    
    pc.baud(115200); 
    pc.printf("-------------------------------------------------- \n\r");
    
    scale.setScale(0);
    scale.tare(); //Reset the scale to 0
    long zero_factor = scale.averageValue(averageSamples);
    pc.printf("Zero factor: %.4f\n\r" , zero_factor);
    scale.setScale(calibration_factor);
    pc.printf("Sensor de Peso Calibrado\n\r" );
    wait(2.0);
    esc1 = 1.0;
    wait(6.0); 
    esc1 = 0.0;
    wait(2.0);
    pc.printf("Motores Activados\n\r" );
    pc.printf("Todo Listo...\n\r" );
    wait(2.0);
    
    pb1.rise(&flip_pb1); 
    pb2.rise(&flip_pb2);
    
    
    thread1.start(extract_data);
    thread2.start( ON_OFF);
    
    
    //F3 = 0.8584*PWM3-0.1502;
    
    while(1) {
        
        esc1 = cnt;
        Thread::wait(20); 
     
    }
}

void rpm_fun()
{
    
}

void extract_data(){
     while(true){
        
        Thread::wait(10);  
    }
}


void ON_OFF(){
    while(true){
        
        if(x == 1){
            weight = scale.getGram();
            pc.printf("%f %.4f %f \n\r",t.read(),weight*1000,cnt);
            cnt = cnt + 0.025;    
        }
        
        if(cnt > 0.95){
           t.reset();
           t.stop();
           cnt = 0.0;
           x = 0;
        }
        
        Thread::wait(4000);
    }
}

void flip_pb1() {
  wait_ms(10);
  t.start();
  x = 1;
}


void flip_pb2() {
    wait_ms(10);

}
