#include "ModeC.h"

void mode_C()
{

    lcd.clear();
    lcd.printString("Mode C",0,0);
    lcd.refresh();
    wait_ms(250);  // small delay to prevent previous press being detected again

    while (button_c.read() == 0) {
        // code goes in here - this acts like the main while(1) loop

        lcd.clear();

        lcd.printString("Mode C",0,0);

        float pot0_val1 = pot_0.read();
        float dist_cm = pot0_val1*200;
        printf("Gap distance = %.0f cm\n",dist_cm);

        speaker.init();
        
        float t = dist_cm*19/4000+0.05;
        speaker.play(1000,t);
        // printf("%0.2f\n",t);

        
        float W1=pot0_val1*-75+75;
        lcd.drawRect(3,27,75,12,FILL_TRANSPARENT);
        lcd.drawRect(3,27,W1,12,FILL_BLACK);

        if (dist_cm<20) {
            blue_led.write(1);
            red_led.write(0);
            green_led.write(1);
        } else {
            blue_led.write(1);
            red_led.write(1);
            green_led.write(1);
        }


        int arrow[5][20] =   {
            { 0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0 },
            { 0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0 },
            { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
            { 0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0 },
            { 0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0 },
        };
        lcd.drawSprite(30,20,5,20,(int *)arrow);



        lcd.refresh();
        wait(t);
    }

}