#include "ModeA.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

void mode_A()
{

    lcd.clear();


    lcd.printString("Mode A",0,0);
    lcd.refresh();
    wait_ms(250);  // small delay to prevent previous press being detected again

    while (button_a.read() == 0) { // code goes in here - this acts like the main while(1) loop

        lcd.clear();

        lcd.printString("Mode A",0,0);

        int petrol[12][11] =   {
            { 0,0,1,1,1,1,1,0,0,0,0 },
            { 0,0,1,0,0,0,1,0,0,1,1 },
            { 0,0,1,0,0,0,1,0,0,1,1 },
            { 0,0,1,0,0,0,1,0,0,0,1 },
            { 0,0,1,0,0,0,1,0,0,1,0 },
            { 0,0,1,1,1,1,1,0,0,1,0 },
            { 0,0,1,1,1,1,1,0,1,0,0 },
            { 0,0,1,1,1,1,1,0,1,0,0 },
            { 0,0,1,1,1,1,1,1,0,0,0 },
            { 0,0,1,1,1,1,1,0,0,0,0 },
            { 1,1,1,1,1,1,1,1,1,0,0 },
            { 1,1,1,1,1,1,1,1,1,0,0 },
        };
        lcd.drawSprite(3,10,12,11,(int *)petrol);

        int temp[19][3] =   {
            { 0,1,0},
            { 1,0,1},
            { 1,0,1},
            { 1,0,1},
            { 1,0,1},
            { 1,0,1},
            { 1,0,1},
            { 1,0,1},
            { 1,0,1},
            { 1,0,1},
            { 1,0,1},
            { 1,0,1},
            { 1,0,1},
            { 1,0,1},
            { 0,1,0},
            { 1,1,1},
            { 1,1,1},
            { 1,0,1},
            { 1,1,1},
        };
        lcd.drawSprite(6,27,19,3,(int *)temp);

        float pot0_val = pot_0.read();
        float pot1_val = pot_1.read();

        lcd.drawRect(16,10,68,12,FILL_TRANSPARENT); // Fuel Bar
        lcd.drawRect(16,30,68,12,FILL_TRANSPARENT); // Temperature Bar

        float W1=pot0_val*67;
        float W2=(pot1_val*67);

        lcd.drawRect(17,11,W1,10,FILL_BLACK);
        lcd.drawRect(17,31,W2,10,FILL_BLACK);

        float Fuel_lvl=pot0_val*100;
        float Engine_temp=(pot1_val*80)+50;
        printf("Fuel level = %.02f%%        Engine temperature = %.02f Degrees C\n", Fuel_lvl, Engine_temp);

        if (Fuel_lvl<20) {
            myled4=1;
        } else {
            myled4=0;
        }

        if (Engine_temp>110) {
            myled1=1;
        } else {
            myled1=0;
        }


        lcd.refresh();
        wait_ms(100);
    }

}