#include "ModeB.h"

DigitalOut myled11(LED1);
DigitalOut myled22(LED2);
DigitalOut myled33(LED3);
DigitalOut myled44(LED4);

void mode_B()
{

    lcd.clear();
    lcd.printString("Mode B",0,0);
    lcd.refresh();
    wait_ms(250);

    while (button_b.read() == 0) {
        // code goes in here - this acts like the main while(1) loop

        lcd.clear();

        float pot0_hbl = pot_0.read();

        if (pot0_hbl>0.2) {
            myled11=1;
        } else {
            myled11=0;
        }
        if (pot0_hbl>0.4) {
            myled22=1;
        } else {
            myled22=0;
        }
        if (pot0_hbl>0.6) {
            myled33=1;
        } else {
            myled33=0;
        }
        if (pot0_hbl>0.8) {
            myled44=1;
        } else {
            myled44=0;
        }


        if (pot0_hbl<0.2) {
            printf("Heater set to level 0");
        } else if (0.8<pot0_hbl) {
            printf("Heater set to level 4");
        } else if (0.6<pot0_hbl) {
            printf("Heater set to level 3");
        } else if (0.4<pot0_hbl) {
            printf("Heater set to level 2");
        } else {
            printf("Heater set to level 1");
        }

        lcd.printString("Mode B",0,0);
        lcd.printString("Cabin temp",0,2);

        float Temp = tmp36.read();
        float temperature = 100.0f*3.3f*Temp - 50.0f;
        printf("     Cabin temperature= %0.2f C\n",temperature);
        
        char temp_val[27];
        sprintf(temp_val,"%.2f C",temperature);
        lcd.printString(temp_val,0,3);
        

        float value = ldr.read();
        if (value>0.5f) {
            blue_led.write(0);
            red_led.write(0);
            green_led.write(0);
        } else {
            blue_led.write(1);
            red_led.write(1);
            green_led.write(1);
        }

        lcd.refresh();
        wait_ms(100);
    }
}
