#include "ModeD.h"

void mode_D()
{
    lcd.clear();
    lcd.printString("Mode D",0,0);
    lcd.refresh();
    wait_ms(250);

    AnalogIn  joy_v(p20);
    AnalogIn  joy_h(p19);

    shift.write(0x3f);

    float gear_ratio;
    float speed;
    float RPM;

    while (button_d.read() == 0) {
        // code goes in here - this acts like the main while(1) loop

        lcd.clear();
        lcd.printString("Mode D",0,0);
        lcd.printString("0",2,17);

        float pot2_val = pot_2.read();
        RPM = pot2_val*5300+700;

        char RPM_val[27];
        sprintf(RPM_val,"%.0f",RPM);
        lcd.printString(RPM_val,25,2);

        lcd.drawRect(5,8,74,7,FILL_TRANSPARENT); // RPM bar
        lcd.drawRect(5,30,74,7,FILL_TRANSPARENT); // Speed bar

        float pot2_acc = pot_2.read();
        lcd.drawRect(6,9,pot2_val*74,6,FILL_BLACK);

        lcd.printString("0",3,5);
        lcd.printString("137",65,5);
        lcd.printString("0",3,2);
        lcd.printString("6000",60,2);

        float xr = joy_h.read();
        float yr = joy_v.read();
        
        if (button_a.read() == 1) {

            if((xr<0.2)&& (yr<0.2)) {
                shift.write(0x31);
                gear_ratio=3.62;
            } else if((0.8<xr)&& (0.8<yr)) {
                shift.write(0x06);
                gear_ratio=3.85;
            } else if((0.8<xr)&& (yr<0.2)) {
                shift.write(0x5B);
                gear_ratio=2.04;
            } else if((0.4<xr)&& (xr<0.6)&& (0.8<yr)) {
                shift.write(0x4F);
                gear_ratio=1.28;
            } else if((0.4<xr)&&(xr<0.6)&& (yr<0.2)) {
                shift.write(0x66);
                gear_ratio=0.95;
            } else if((xr<0.2)&& (0.8<yr)) {
                shift.write(0x6D);
                gear_ratio=0.76;
            } else {
                shift.write(0x3f);
                gear_ratio=1000000000;
            }
            
        }

        speed=(0.001174392*RPM*60)/(gear_ratio*4.07);
        printf("RPM = %1.0f  speed = %.0f mph\n",RPM,speed);

        lcd.drawRect(5,30,speed*37/68,7,FILL_BLACK);
        
        char speed_val[27];
        sprintf(speed_val,"%.0f",speed);
        lcd.printString(speed_val,27,5);

        lcd.refresh();
        wait_ms(100);
    }

}