/*
Author             : Akram khan
RTOS:              : project
file               : main.cpp
library inculded   :mbed.h, C12832_lcd.h, mbed-rtos.h
Description: RTOS project connected and automated manufacturing plant.
The Goal of this project is to use most of the  IO on the mbed application board in a RTOS project.

This simulates a manufacturing plant where temperature, speed, potentiometer, 
lever control are performed and  depending on the input and stored 
values alerts are  issues on  COM port, buzzer and LEDS.
The LCD display and Ethernet control is used to display and collect logs.

                                                                   */
#include "mbed.h"
#include "rtos.h"
#include "C12832_lcd.h"
#include "beep.h"  
#include "LM75B.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "SimpleSMTPClient.h"

//----------------------------------------------------------------------------
#define LCD1 lcd.locate(0, 0);              // LCD line 1.
#define LCD2 lcd.locate(0,11);              // LCD line 2.
#define LCD3 lcd.locate(0,22);              // LCD line 3.
//----------------------------------------------------------------------------

#define MetroDuration      60.0                   // controller  duration for on-time in seconds.
#define LCD_refresh        0.1                    // how often to redraw the LCD.
#define Delay                1                    // how long the LED-on-time is.




#define DOMAIN "comcast.net"
#define SERVER "smtp.comcast.net"
#define PORT "587" //25 or 587,465(OutBound Port25 Blocking )
#define USER "rtos_test"
#define PWD "test"
#define FROM_ADDRESS "rtos_test@comcast.net"
// TO_ADDRESS (Of some address is possible.)
// to-user1@domain, to-user2@domain, to-user3@domain ....
// The TO_ADDRESS are less than 128 characters.
#define TO_ADDRESS "rtos_test@comcast.net" 

#define SUBJECT "Test Mail"



//----------------------------------------------------------------------------
   // TextLCD lcd(p24, p26, p27, p28, p29, p30);
    DigitalOut   buzzer(p26) ;                               // Buzzer to alert the cooking stopped.
    LM75B       temperature(p28,p27);                // Temperature sensor
    C12832_LCD  lcd;                                 // LCD object from library.
    DigitalOut  led3(LED3);                          //  LED to display  cooking in progress
    DigitalOut  led2(LED2);                          //  LED to display  carousel turning
    AnalogIn pot1(p20);                              // Analog Potentiometer 1
    AnalogIn pot2(p19);                              // Analog Potentiometer 1
    Serial      pc(USBTX, USBRX);               // PuTTY terminal communication.
  //---------------- Interrupts------------------------------------------------------------  
    InterruptIn  InterJoyStickUp    (p15);          // joystick beat up pressed that will make controller stop
    InterruptIn  InterJoyStickDown  (p12);          // joystick beat up pressed that will make controller start
    InterruptIn  InterJoyStickLeft  (p13);          // joystick beat up pressed that will make clock time up.
    InterruptIn  InterJoyStickRight (p16);          // joystick beat up pressed that will make clock time down.
    InterruptIn  InterJoyStickCenter(p14);          //joystick beat up pressed that will make open close the door.
    InterruptIn  Interpotmeter1(p20);               // Potentiometer 1. 
    InterruptIn  Interpotmeter2(p19);               // Potentiometer 2. 
    
//----------------------------------------------------------------------------
    
    Ticker      tickercontroller;                // blinking LED.
    Ticker      tickerLCD;                      // display ticker.
    Timeout     timeoutDutyCycle;               // LED duty cycle delay.
    Timeout     timeoutcontroller;
    //----------------------------------------------------------------------------
    void lcd_display();                         // Display on LCD.
    void int_ser_controller();                   // Ticker for MV.                
    void up_isr();                         // Stop the MV.
    void down_isr();                       // Start the MV.
    void right_rising_isr();               // Lower the clock.
    void left_rising_isr();                // Raise the clock.
    void default_isr();                    // reset
    void off_controller();                  // turn off blinker.
    void pot1_isr();                        // Potentiometer 1. 
    void pot2_isr();                        // Potentiometer 2.
    //----------------------------------------------------------------------------
float potmeter1 ;                                // intial Potentiometer 1
float potmeter2 ;                                // intial Potentiometer 2
float temp ;                                // intial temperature of controller 
char  controller_is_ON;                                 // to check if LED should blink.
//--------------------Start of Main--------------------------------------------------------
int main(void)
{
    temp = temperature.read();                       // read the temperature.
     potmeter1= pot1.read() ;                        // read the Potentiometer 1
     potmeter2= pot2.read() ;                       // read the Potentiometer 2
     
    //----------------------------------------------------------------------------
    Interpotmeter1.rise (&pot1_isr);           //  Change the potentiometer 1 control.
    Interpotmeter2.rise (&pot2_isr);           //  Change the potentiometer 2 control.
    InterJoyStickDown.rise (&down_isr);           // Start the controller.
    InterJoyStickUp.rise   (&up_isr);             // Stop the controller.
    InterJoyStickRight.rise(&right_rising_isr);   // Lower the clock time.
    InterJoyStickLeft.rise (&left_rising_isr);    // Raise the clock time .
    InterJoyStickCenter.rise(&default_isr);       // Reset the controller to deafult value .
    //----------------------------------------------------------------------------   
    tickercontroller.attach(&int_ser_controller,Delay);      //Ticker for Interuppt for the service
    tickerLCD.attach(&lcd_display,LCD_refresh);            // Ticker for display on  LCD.                    
    //----------------------------------------------------------------------------     
     /*while(1)                                  
      {
        wait(20.0);
      } */
      EthernetInterface eth;
    char strTimeMsg[16];
    lcd.cls();
    printf("\n\n/* SimpleMTPClient library demonstration */\n");

    printf("Setting up ...\n");
    eth.init();
    eth.connect();
    printf("Connected OK\n");

    // IP Address 
    printf("IP Address is %s\n", eth.getIPAddress());
    lcd.locate(0,1);
    lcd.printf("%s", eth.getIPAddress());

    // NTP Client
    printf("NTP setTime...\n");
    NTPClient ntp;
    ntp.setTime("pool.ntp.org");
    
    time_t ctTime = time(NULL)+32400; // JST
    printf("\nTime is now (JST): %d %s\n", ctTime, ctime(&ctTime));
    strftime(strTimeMsg,16,"%y/%m/%d %H:%M",localtime(&ctTime));

    lcd.locate(0,0);
    lcd.printf("[%s]",strTimeMsg);


    SimpleSMTPClient smtp;
    int ret;
    char msg[]="Hello SimpleSMTPClient ";
    
    smtp.setFromAddress(FROM_ADDRESS);
    smtp.setToAddress(TO_ADDRESS);
    smtp.setMessage(SUBJECT,msg);
    smtp.addMessage("TEST TEST TEST\r\n");
  
    ret = smtp.sendmail(SERVER, USER, PWD, DOMAIN,PORT,SMTP_AUTH_PLAIN);
 
    if (ret) {
        printf("E-mail Transmission Error\r\n");
    } else {
        printf("E-mail Transmission OK\r\n");
    }
    
    //
    // send as SMS text 
    //
    
    smtp.setFromAddress(FROM_ADDRESS);
    smtp.setToAddress("5105794214@txt.att.net");                // MODIFY for carrier
    smtp.setMessage(SUBJECT,msg);
    smtp.addMessage("TEST TEST TEST\r\n");
  
    ret = smtp.sendmail(SERVER, USER, PWD, DOMAIN,PORT,SMTP_AUTH_PLAIN);
 
    if (ret) {
        printf("SMS Transmission Error\r\n");
    } else {
        printf("SMS Transmission OK\r\n");
    }
 
    return 0;
    }

//------------End of main ----------------------------------------------------------------

//------------------ Start of ISRs----------------------------------------------------------
void pot1_isr(void)                           // Change the potentiometer 1 control
    {
      controller_is_ON  = 0;
    }
    //----------------------------------------------------------------------------   
    void pot2_isr(void)                           // Change the potentiometer 2 control
    {
      controller_is_ON  = 0;
    }
    //----------------------------------------------------------------------------
     void down_isr(void)                         // Turn on the controller  with timeout of 3 mintues.
    {
      controller_is_ON  = 1;
      timeoutcontroller.detach();
      timeoutcontroller.attach(&off_controller,MetroDuration);
    }
    //----------------------------------------------//----------------------------
     
    void up_isr(void)                           // Up presssed tun off the controller.
    {
      controller_is_ON  = 0;
    }
    //----------------------------------------------//----------------------------
    
    void left_rising_isr(void)                  // Left button pressed, increase the clock time .
    {
      __disable_irq();                          
       
       temp = temp + 0.10;                             
   
       
       __enable_irq();                          
    }                                         
      
    
   
    
    void right_rising_isr(void)                 // Right button pressed, decrease  the clock time .
    {
         __disable_irq();                        
      
         temp = temp - 0.10;                                 // decrease BPM.
                                  
         __enable_irq();                           // safe by now.
      
    }


   

    void default_isr(void)                       // Center button pressed and set to pause the MV.
    {
      
     tickercontroller.detach();                 
     timeoutcontroller.attach(&off_controller,MetroDuration);
    }
//----------------------------------------------//----------------------------//
    void lcd_display(void)                      // Display the state of  controller  and temperature.
    {
      lcd.cls();                                // clear  LCD display.
      
      LCD1;                                     // line 1.
      if ( controller_is_ON ){
          
      LCD1; 
      lcd.printf("  controller RUNNING");
       LCD2;                                     // line 2.
     lcd.printf(" temp =%i\r\r",temp);
     led2 = 0;
    buzzer = 1; }                          // buzzer to indicate cooking done
      else {
      led2 = 1;
      LCD1; 
      lcd.printf("  controller STOPPED");
     LCD2;                                     // line 2.
     lcd.printf(" temp =%i\r\r",temp);
      buzzer  = 0;                         // turn off the buzzer to indicate the cooking done.
     }
     
    }
  //----------------------------------------------//----------------------------   
    void int_ser_controller()                  // Ticker for controller.
    {        
      if (controller_is_ON)
      {
        tickercontroller.detach();               
        tickercontroller.attach(&int_ser_controller,Delay);      
        led3 = 1;
      } else
        led3 = 0;
    }
//----------------------------------------------//----------------------------
    void off_controller(void)               // Stop the controller.
    {
      controller_is_ON=0;
     
      
    } 
    

/* Test cases
 Move the Joystick down and notice the controller  will start
 Move the Joystick up and notice the controller  will stop
 Move the Joystick left and notice the controller clock will increaase and the LCD display wil show the display.
 Move the joystick right and notice the controller clock will decrease and the LCD display will show the  display.
 When the maximun  time of the clock is reached the  clock will set to default.
 The LCD will also show the temperature of the controller and  will be increamented based on the  joystick
 The joystick can be pressed in center position to open the door and pause the cooking.
 The LED will also show running and stopped as status of the controller.
 LED2 will show the status of the door.
 */