
#include "mbed.h"

#ifndef __TIME_BASE_TRAPEZOIDAL_MOTION_CAL_H__
#define __TIME_BASE_TRAPEZOIDAL_MOTION_CAL_H__


class timeBaseTrapezoidalMotionCal{
    
public:
    
    timeBaseTrapezoidalMotionCal(double f_start, double f_stop, double f_max, double a_up, double a_down);
    
    void setTarg(int32_t targ);
    
    int32_t calSteps(int32_t time_ms);
    
private:
    double _f_start;
    double _f_stop;
    double _f_max;
    double _a_up;
    double _a_down;
    
    double step_accel;
    double step_decel;
    double step_const;
    double f_reach;
    
    double t_accel;
    double t_const;
    double t_decel;
    
    int32_t targSteps;
    
    int shortMode;
    int revMode;
    
};




#endif

