
#include "mbed.h"
#include "STM_seq.h"

stepMotor::stepMotor(PinName pinName_CLK , PinName pinName_DIR , PinName pinName_Sleep , PinName pinName_Fault)
    : pin_CLK(pinName_CLK) , pin_DIR(pinName_DIR) , pin_Sleep(pinName_Sleep) , pin_Fault(pinName_Fault)
{
    
    pin_CLK = 0;
    pin_DIR = 0;
    pin_Sleep = 0;
    
}

stepMotor::~stepMotor(){}

void stepMotor::oneStep(bool direction)
{
    
    pin_DIR = direction?1:0;
    wait_us(2);
    pin_CLK = 1;
    wait_us(2);
    pin_CLK = 0;
    
}

void stepMotor::setSleep(bool enable)
{
    pin_Sleep = enable?1:0;
}
    
bool stepMotor::getSleep()
{
    return (pin_Sleep != 0);
}

bool stepMotor::getFault()
{
    return (pin_Fault != 0);
}



