
#include "mbed.h"
#include "SPM.h"

stepMotor::stepMotor(PinName pinName_A , PinName pinName_nA , PinName pinName_B , PinName pinName_nB)
    : pin_A(pinName_A) , pin_nA(pinName_nA) , pin_B(pinName_B) , pin_nB(pinName_nB) {
    
    pin_A = pin_nA = pin_B = pin_nB = 0;
    state=0;
    
}

stepMotor::~stepMotor(){}

void stepMotor::oneStep(bool direction){
    
#ifdef __P1_EXCITATION__
    switch(state){
        case 0 : pin_A  = 1; pin_B  = pin_nA = pin_nB = 0; break;
        case 1 : pin_B  = 1; pin_nA = pin_nB = pin_A  = 0; break;
        case 2 : pin_nA = 1; pin_nB = pin_A  = pin_B  = 0; break;
        case 3 : pin_nB = 1; pin_A  = pin_B  = pin_nA = 0; break;
    }
    if(direction){
        if(state<3)state++;
        else state=0;
    }else{
        if(state>0)state--;
        else state=3;
    }
#elif defined __P12_EXCITATION__
    switch(state){
        case 0 : pin_A           = 1; pin_B  = pin_nA = pin_nB = 0; break;
        case 1 : pin_A  = pin_B  = 1; pin_nA = pin_nB          = 0; break;
        case 2 : pin_B           = 1; pin_nA = pin_nB = pin_A  = 0; break;
        case 3 : pin_B  = pin_nA = 1; pin_nB = pin_A           = 0; break;
        case 4 : pin_nA          = 1; pin_nB = pin_A  = pin_B  = 0; break;
        case 5 : pin_nA = pin_nB = 1; pin_A  = pin_B           = 0; break;
        case 6 : pin_nB          = 1; pin_A  = pin_B  = pin_nA = 0; break;
        case 7 : pin_nB = pin_A  = 1; pin_B  = pin_nA          = 0; break;
    }
    if(direction){
        if(state<7)state++;
        else state=0;
    }else{
        if(state>0)state--;
        else state=7;
    }
#elif defined __P2_EXCITATION__
    switch(state){
        case 0 : pin_nB = pin_A  = 1; pin_B  = pin_nA = 0; break;
        case 1 : pin_A  = pin_B  = 1; pin_nA = pin_nB = 0; break;
        case 2 : pin_B  = pin_nA = 1; pin_nB = pin_A  = 0; break;
        case 3 : pin_nA = pin_nB = 1; pin_A  = pin_B  = 0; break;
    }
    if(direction){
        if(state<3)state++;
        else state=0;
    }else{
        if(state>0)state--;
        else state=3;
    }
#endif
    
}

void stepMotor::free(){
    pin_A = pin_nA = pin_B = pin_nB = 0;
}

void stepMotor::lock(){
    #ifdef __P1_EXCITATION__
    switch(state){
        case 0 : pin_A  = 1; pin_B  = pin_nA = pin_nB = 0; break;
        case 1 : pin_B  = 1; pin_nA = pin_nB = pin_A  = 0; break;
        case 2 : pin_nA = 1; pin_nB = pin_A  = pin_B  = 0; break;
        case 3 : pin_nB = 1; pin_A  = pin_B  = pin_nA = 0; break;
    }
#elif defined __P12_EXCITATION__
    switch(state){
        case 0 : pin_A           = 1; pin_B  = pin_nA = pin_nB = 0; break;
        case 1 : pin_A  = pin_B  = 1; pin_nA = pin_nB          = 0; break;
        case 2 : pin_B           = 1; pin_nA = pin_nB = pin_A  = 0; break;
        case 3 : pin_B  = pin_nA = 1; pin_nB = pin_A           = 0; break;
        case 4 : pin_nA          = 1; pin_nB = pin_A  = pin_B  = 0; break;
        case 5 : pin_nA = pin_nB = 1; pin_A  = pin_B           = 0; break;
        case 6 : pin_nB          = 1; pin_A  = pin_B  = pin_nA = 0; break;
        case 7 : pin_nB = pin_A  = 1; pin_B  = pin_nA          = 0; break;
    }
#elif defined __P2_EXCITATION__
    switch(state){
        case 0 : pin_nB = pin_A  = 1; pin_B  = pin_nA = 0; break;
        case 1 : pin_A  = pin_B  = 1; pin_nA = pin_nB = 0; break;
        case 2 : pin_B  = pin_nA = 1; pin_nB = pin_A  = 0; break;
        case 3 : pin_nA = pin_nB = 1; pin_A  = pin_B  = 0; break;
    }
#endif
}


