#include "mbed.h"
#define c2f(h, l, n, e) float(short(h << 8| 1)) / (1 << 16 - n + e)

int main() {
    I2C i2c(p28, p27);
    char id = 0x60 << 1, data[16];
    
    data[0] = 0x12, data[1] = 0x01;
    i2c.write(id, data, 2);
    wait_ms(1);
    
    data[0] = 0;
    i2c.write(id, data, 1, true);
    i2c.read(id, data, 16);
    float padc = data[0] << 2 | data[1] >> 6;
    float tadc = data[2] << 2 | data[3] >> 6;
    float a0 = c2f(data[4], data[5], 16, 3);
    float b1 = c2f(data[6], data[7], 16, 13);
    float b2 = c2f(data[8], data[9], 16, 14);
    float c12 = c2f(data[10], data[11], 14, 22);
    float c11 = c2f(data[12], data[13], 11, 21);
    float c22 = c2f(data[14], data[15], 11, 25);
    float pcomp = a0 + (b1 + c11 * padc + c12 * tadc) * padc + (b2 + c22 * tadc) * tadc;
    
    printf("pressure = %4.0f hpa\n", pcomp * 650 / 1023 + 500);    
}
