/*
@author Akira Kashihara <akira.kashihara@gmail.com>
@suthor Kenta Osaki
*/
#include "mbed.h" //use mbed basic library                                                                               <include start
#include "MPL115A2.h" // use MPL115A2 library
#include "MMA7361L.h" //use MMA7361L library use 
#include "rtos.h" //use rtos library                                                                                     <include end

LocalFileSystem local("local");  //use Local file system                                                                 <file system define

Timer timer; //use timer                                                                                                 <which pin does system use?(start)
MMA7361L accel(p17, p18, p19, p23, p24, p22); //decide pin number of accel
AnalogIn lm60(p20); // decide pin number of tempareture
DigitalIn endsw(p5); // decide pin number of end switch
DigitalIn startsw(p6); //decide pin number of start switch
BusOut leds(LED1, LED2, LED3, LED4); // decide led number of system check
AnalogIn hu(p16); // decide pin number of humidity
//AnalogIn illu(p15);
Serial xbee(p28,p27); //decide pin number of xbee and decide Serial using
Serial gps(p13, p14); // decide pin number of gps                                                                        <which pin does system use?(end)

long int begin, end;// timer define
long int begin_1 = 0;

FILE *fp = fopen("/local/cansat.txt", "a"); //file system start, file open                                               <about file system to open "cansat.txt"

char gps1[1000];
char GPS[1000];
int timer_count = 0;
int xbee_count = 0;
bool xbee_flag = true;
bool gps_flag = true; //about gps_flag define(true)                                                                      <gps_define(true)
bool gps_get = true; //which gps get or lost
bool stateSW = false; //about switch flag define(false)                                                           //  <stateSW(false)
int at = 20; // define avarage time

void gps_thread(void const *argument)                                //   <gps thread start
{
    while (gps_flag) {            //if gps_flag is true, while can run                                                   <gps data scan start
        gps.scanf("%s", gps1);
        if (gps1[3] == 'R' && gps1[4] == 'M' && gps1[5] == 'C') {     //if gps1 is $GPGGA, this program can write data   <what data do I want get
            gps.scanf("%s\r\n", GPS);
            gps_get = true;
        }
    }
}

int main()
{

    float press_buff = 0;  //press buffer is 0                                                                            <buff define start
    float temp_buff = 0;   //temparature buffer is 0
    float humi_buff = 0;   //humidity buffer is 0
    float accelx_buff = 0; //accelx buffer is 0
    float accely_buff = 0; //accely buffer is 0
    float accelz_buff = 0; //accelz buffer is 0                                                                           <buff define end

    accel.setScale(MMA7361L::SCALE_6G); //6g mode
    accel.calibrate(MMA7361L::SCALE_6G, -0.96, 1.06, -0.78, 1.28, -1.14, 0.78); //calibration of accelation               <calibration of accelation

    MPL115A2 mpl115a2(p9, p10); //define pressure pin number                                                              <pressure pin number define

//____define of main program(end)

//____run main program(start)

    while (true) {

        leds = 1;  //                                                                                                     <led start(if mbed get A)
        wait(1.0);
        leds = 0;
        wait(1.0);

        if (startsw != stateSW) {  //if start switch is pushed bu anyone run                                              <get data start(if push start switch)
            stateSW = !stateSW;
            if (stateSW) {

                timer.start(); //timer start                                                                              <timer caunt system start
                begin = timer.read_us(); //timer number read

                Thread thread(gps_thread); //gps thread run

                while (true) {

                    leds = 1;
                    press_buff = 0; //pressure buffer reset                                                               <buffer reset(start)
                    temp_buff = 0; //temparture buffer reset
                    humi_buff = 0; //humidity buffer reset
                    accelx_buff = 0; //accelx buffer reset
                    accely_buff = 0; //accely buffer reset
                    accelz_buff = 0; //accelz buffer reset                                                           // <buffer reset(end)
                    leds = 0;
                    leds = 2;

                    for (int i = 0; i < at; i++) {   //get data and + 20 times (loop)                                     <get data loop(start)
                        temp_buff += (3.3 * lm60 - 0.424) / 0.00625; //temperture data calculation
                        press_buff += mpl115a2.readPressure(); //pressure get data(this calculation is run by library)
                        humi_buff += hu * 3.3 * 100; //humidity data culculation
                        accelx_buff += accel.getAccelX(); //accelx get
                        accely_buff += accel.getAccelY(); //accely get
                        accelz_buff += accel.getAccelZ(); //accelz get
                        wait(0.005);
                    }

                    leds = 0;

                    float tempv = temp_buff / at;                                                                  //    <avarage data(start)
                    float press = press_buff / at;
                    float humi = humi_buff / at;
                    float accelX = accelx_buff / at;
                    float accelY = accely_buff / at;
                    float accelZ = accelz_buff / at;                                                               //    <avarage data(end)
                    //   float lx = illu * 3.3 / 3 * 1000;

                    end = timer.read_us() - timer_count*2000;
                    double timers = 1.0 * (end - begin ) / 1000000;

                    if(timers > 2000) {
                        timer_count ++;
                        begin = timer.read_us() - timer_count * 2000; //timer number read
                        timers = (end - begin) / 1000000;
                    }


                    if(xbee_count > 6) {
                        double stop_timer = 1.0 * (end - begin_1) / 1000000;
                        if(stop_timer > 60 * 30) {
                            fclose(fp);
                            timer.stop();
                            gps_get = 1;
                            gps_flag = 1;
                            xbee.printf("CanSat was able to close the file\r\n");
                            while(true) {
                                leds = 8;
                                wait(1.0);
                                leds = 0;
                                wait(1.0);
                            }
                        }
                    }
                    /*                   if(lx > 800) {
                                           xbee_count ++;

                                           if(xbee_count >= 5) {
                                               xbee_flag = true;
                                               if(xbee_count == 5) {
                                                   begin_1 = timer.read_us();
                                               }
                                           }
                                       }*/
                    leds = 4;

                    if (gps_get == false) {
                        fprintf(fp, "$DATA,%4.1f,%4.1f,%2.2f,%2.2f,%2.2f,%4.1f,%4.1f,#end\r\n", timers + timer_count * 2000, tempv, accelX, accelY, accelZ, press, humi);
                        if(xbee_flag == true) {
                            xbee.printf("$DATA,%4.1f,%4.1f,%2.2f,%2.2f,%2.2f,%4.1f,%4.1f,#end\r\n", timers + timer_count * 2000, tempv, accelX, accelY, accelZ, press, humi);
                        }
                    }

                    if (gps_get == true) {
                        leds = 15;
                        if(xbee_flag == true) {
                            xbee.printf("%s,#end\r\n", GPS);  //GPS data is dent by xbee
                        }
                        fprintf(fp, "%s,#end\r\n", GPS);  //GPS data is writen to mbed                                              <write system(GPS)
                        gps_get = false;
                        leds = 0;
                    }

                    leds = 0;
                    leds = 8;

                    wait(0.1);

                    if (endsw != stateSW) {
                        stateSW = !stateSW;

                        if (stateSW) {
                            fclose(fp);
                            timer.stop();
                            gps_flag = 0;

                            while (true) {
                                leds = 8;
                                wait(1.0);
                                leds = 0;
                                wait(1.0);
                            }

                        }

                    }

                }
            }
        }
    }
}