//---------------------------------------------------------------------------
// Attitude measurement using some attitude estimation filter
// Filter : Complementary filter / Extended Kalman filter / Madgewick filter
// IMU : MPU-9250
// Written by Akira Heya
// DATE : 2018/12/05
//---------------------------------------------------------------------------

//----include
#include "mbed.h"
#include "MPU9250.h"
#include "EKF.h"
#include "math.h"

//----variable
char buffer[14];
//----Instance
MPU9250 mpu9250;
EKF ekf;
Timer t;
Serial pc(USBTX, USBRX);

//****MAIN****
int main()
{
  //----Serial baud rate
  pc.baud(921600);
  //----I2C clock rate
  i2c.frequency(400000);
  //----System clock
  //pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);
  //----Timer start
  t.start();
  // Read the WHO_AM_I register, this is a good test of communication
  uint8_t whoami = mpu9250.readByte(MPU9250_ADDRESS, WHO_AM_I_MPU9250);
  pc.printf("I2C check : 0x%x\n\r", whoami);
  //----Self check
    if (whoami == 0x71)
    {
        pc.printf("MPU9250 is online\n\r");
        sprintf(buffer, "0x%x", whoami);
        wait(1);
        //----Reset registers to default in preparation for device calibration
        mpu9250.resetMPU9250();
        //----Start by performing self test and reporting values
        mpu9250.MPU9250SelfTest(SelfTest);
        pc.printf("x-axis self test: acceleration trim within : %f % of factory value\n\r", SelfTest[0]);
        pc.printf("y-axis self test: acceleration trim within : %f % of factory value\n\r", SelfTest[1]);
        pc.printf("z-axis self test: acceleration trim within : %f % of factory value\n\r", SelfTest[2]);
        pc.printf("x-axis self test: gyration trim within : %f % of factory value\n\r", SelfTest[3]);
        pc.printf("y-axis self test: gyration trim within : %f % of factory value\n\r", SelfTest[4]);
        pc.printf("z-axis self test: gyration trim within : %f % of factory value\n\r", SelfTest[5]);
        // Calibrate gyro and accelerometers, load biases in bias registers
        mpu9250.calibrateMPU9250(gyroBias, accelBias);
        pc.printf("x gyro bias = %f\n\r", gyroBias[0]);
        pc.printf("y gyro bias = %f\n\r", gyroBias[1]);
        pc.printf("z gyro bias = %f\n\r", gyroBias[2]);
        pc.printf("x accel bias = %f\n\r", accelBias[0]);
        pc.printf("y accel bias = %f\n\r", accelBias[1]);
        pc.printf("z accel bias = %f\n\r", accelBias[2]);
        wait(1);
        //----Initialize device for active mode read of acclerometer, gyroscope, and temperature
        mpu9250.initMPU9250();
        pc.printf("MPU9250 initialized for active data mode....\n\r");
        pc.printf("Accelerometer full-scale range = %f  g\n\r", 2.0f*(float)(1<<Ascale));
        pc.printf("Gyroscope full-scale range = %f  deg/s\n\r", 250.0f*(float)(1<<Gscale));
        wait(1);
    }
    else
    {
        pc.printf("Could not connect to MPU9250: \n\r");
        pc.printf("%#x \n",  whoami);
        sprintf(buffer, "WHO_AM_I 0x%x", whoami);
        //----Loop forever if communication doesn't happen
        while(1) ;
    }
    //----Get accelerometer sensitivity
    mpu9250.getAres();
    //----Get gyro sensitivity
    mpu9250.getGres();
    pc.printf("Accelerometer sensitivity is %f LSB/g \n\r", 1.0f/aRes);
    pc.printf("Gyroscope sensitivity is %f LSB/deg/s \n\r", 1.0f/gRes);
    wait(1);
    //****LOOP****
    while(1)
    {
        //----Time interval
        Now = t.read_us();
        delt_t = (Now - lastUpdate)/1000000.0f;
        lastUpdate = Now;
        
        //----Acceleration sensor
        mpu9250.readAccelData(accelCount);
        // Calculate the accleration value into actual g's
        ax = (float)accelCount[0]*aRes - accelBias[0];  // get actual g value, this depends on scale being set
        ay = (float)accelCount[1]*aRes - accelBias[1];
        az = (float)accelCount[2]*aRes - accelBias[2];
        th_ax = atan2(ay,sqrt(ax*ax+az*az))*(180.0f/PI);
        th_ay = -1*atan2(ax,az)*(180.0f/PI);

        //----Gyroscope
        mpu9250.readGyroData(gyroCount);
        // Calculate the gyro value into actual degrees per second
        gx = (float)gyroCount[0]*gRes - gyroBias[0];  // get actual gyro value, this depends on scale being set
        gy = (float)gyroCount[1]*gRes - gyroBias[1];
        gz = (float)gyroCount[2]*gRes - gyroBias[2];

        th_gx += (pre_gx + gx) * delt_t/2.0f;
        th_gy += (pre_gy + gy) * delt_t/2.0f;
        th_gz += (pre_gz + gz) * delt_t/2.0f;
        pre_gx = gx;
        pre_gy = gy;
        pre_gz = gz;

        //----Complementary filter
        th_x = 0.95*(th_x + (pre_gx + gx) * delt_t/2.0f) + 0.05*th_ax;
        th_y = 0.95*(th_y + (pre_gy + gy) * delt_t/2.0f) + 0.05*th_ay;
        
        //----Extended Kalman filter
        dt0_ekf = t.read_us();
        ekf.ExtendedKalmanFilterUpdate(th_ax, th_ay, pre_gx, pre_gy, pre_gz);
        dt1_ekf = t.read_us() - dt0_ekf;
        
        //----Madgwick filter
        dt0_mwf = t.read_us();
        mpu9250.MadgwickFilterUpdate_6axis(ax, ay, az, gx, gy, gz);
        roll  = atan2(2.0f * (q1 * q2 + q3 * q4), q1 * q1 - q2 * q2 - q3 * q3 + q4 * q4);
        roll  *= 180.0f / PI;
        //roll = 0.995f*pre_roll + 0.005f*roll;
        
        pitch = -asin(2.0f * (q2 * q4 - q1 * q3));
        pitch *= 180.0f / PI;
        //pitch = 0.995f*pre_pitch + 0.005f*pitch;
        dt1_mwf = t.read_us() - dt0_mwf;
        
        pre_roll = roll;
        pre_pitch = pitch;
        
        //----Serial print
        sum_dt += delt_t;
        if (sum_dt > 0.0050f)
        {
            //pc.printf("%f, %f\n", dt1_ekf, dt1_mwf);
            pc.printf("%8.3f , %8.3f , %8.3f ,%8.3f\n", t.read(), th_x, th_y, estAlpha, estBeta);
            sum_dt = 0.0f;
        }
    }
}
