#include "StrLib.h"

long long A2I(string str, unsigned int base)   // Error; rtn '-1'
{
    long long ans= 0;   // 64bit
    int tmp= 0;         // 32bit
    int leng= str.size();   // String Length;
    unsigned int chr;
    for(int i= 0; i < leng; i++) {
        chr= str[leng-1-i];
        if('0'<=chr && '9'>=chr)
            tmp= chr-'0';
        else if('A'<=chr && 'F'>=chr)
            tmp= chr-'A'+0x0A;   // ex. C=12= 2(C-A)+ 10(0x0A)
        else if('a'<=chr && 'f'>=chr)
            tmp= chr-'a'+0x0A;
        else
            return -1;

        ans+= (long long)((double)tmp* pow((double)base,(double)i));
    }
    return ans;
}
string I2A(int num, unsigned int base, unsigned int digitNum)
{
    char tmpChr[33];
    // "%5.5dなどとしたい
    string format= "%";

    // Digit Num.
    if(digitNum > 0) {  // 0以外
        unsigned int tmp;
        tmp= '0'+ digitNum;
        format += tmp;
        format += ".";
        format += tmp;   // +でつなげると、charの和（オーバーフロー）起こす。
    }

    if(     base == 8)
        format += "o";
    else if(base == 10)
        format += "d";
    else if(base == 16)
        format += "x";
    else
        return "ERR; base: Oct, Dec, Hex.";

    sprintf(tmpChr, format.c_str(), num);
    string tmpStr= tmpChr;
    return tmpStr;
}
string I2A(long long num, unsigned int base, unsigned int digitNum)
{
    char tmpChr[33];
    // "%5.5dなどとしたい
    string format= "%";

    // Digit Num.
    if(digitNum > 0) {  // 0以外
        unsigned int tmp;
        tmp= '0'+ digitNum;
        format += tmp;
        format += ".";
        format += tmp;   // +でつなげると、charの和（オーバーフロー）起こす。
    }

    if(     base == 8)
        format += "llo";
    else if(base == 10)
        format += "lld";
    else if(base == 16)
        format += "llx";
    else
        return "ERR; base: Oct, Dec, Hex.";

    sprintf(tmpChr, format.c_str(), num);
    string tmpStr= tmpChr;
    return tmpStr;
}

string F2A(float num, int fieldWidth, int decimalPlaces, bool fill0)
{
    if(!(0<=fieldWidth && fieldWidth<30))
        return "ERR; fieldWidth.";
    if(!(0<=decimalPlaces && decimalPlaces<30) )
        return "ERR; decimalPlaces.";
    if(fieldWidth < decimalPlaces+2)
        return "ERR; fieldWidth < decimalPlaces+2";

    char tmpChr[33];
    string format= "%";
    if(fill0)
        format += "0";
    format += I2A(fieldWidth)+ "."+ I2A(decimalPlaces)+ "f";
    sprintf(tmpChr, format.c_str(), num);
    string tmpStr= tmpChr;
    return tmpStr;
}
string F2A(float num)
{
    char tmpChr[33];
    sprintf(tmpChr, "%f", num);
    string tmpStr= tmpChr;
    return tmpStr;
}

bool strCompare(string trg, string cmp, int idx)
{
    int id= trg.find(cmp, idx);
    if(id == string::npos)
        return false;
    return id == idx;
}
bool strCompareComplete(string trg, string cmp)
{
    int idx= trg.find(cmp);
    if(idx == string::npos)
        return false;
    idx= cmp.find(trg);
    if(idx == string::npos)
        return false;

    return true;
}

string toAlpanumeric(string str, bool toLarge)
{
    string ans= "";
    bool num, small, large;
    for (int i= 0; i < str.size(); i++) {
        num= small= large= false;
        if('0' <= str[i] && str[i] <= '9')
            num= true;
        else if('A' <= str[i] && str[i] <= 'Z')
            large= true;
        else if('a' <= str[i] && str[i] <= 'z')
            small= true;

        if(toLarge && small)
            str[i] -= 0x20;  // small -> large
        if(num || large || small)
            ans += str[i];
    }

    return ans;
}