#pragma once

#include "mbed.h"
#include <string>



/** String(Ascii) -> "long long"(64bit) integer.
 *
 * @param   string target(str), int Base(8:Oct, 10:Dec, 16:Hex)
 * @return  long long int. if -1; error.
*/
long long A2I(string str, unsigned int base);

/** int -> string
 *
 * @param   int target(num), int Base(8:Oct, 10:Dec, 16:Hex), int Number of digit
 * @return  string str
*/
string I2A(int num, unsigned int base= 10, unsigned int digitNum= 0);
string I2A(long long num, unsigned int base= 10, unsigned int digitNum= 0);

/** float -> string
 *
 *  Overload; Output format.
 *  @param float target(num), int Field-width, int Number of decimal-places.
 *  @return string.
*/
string F2A(float num, int fieldWidth, int decimalPlaces, bool fill0= false);
string F2A(float num);

/** string Compare
 *
 * @param   string target, string cmp, int index in target
 * @return  bool
*/
bool strCompare(string trg, string cmp, int idx);   // trg内にcmpが存在する位置がidxか判定。

bool strCompareComplete(string trg, string cmp);

/** Eraze others Alphameric, and convert lower-cases to capitals.
 *
 *  @param  string target, bool to-capitals.
 *  @return string
*/
string toAlpanumeric(string str, bool large=false);

// EOF