#include "RealTimeClock.h"

RealTimeClock::RealTimeClock(TimeZone tz)
{
    setTimeZone(tz);
}
RealTimeClock::RealTimeClock(float hour)
{
    setTimeZone(hour);
}
void RealTimeClock::setSecondsRealTime()
{
    secRT = time(NULL);
    secRT += this->offsetTimeZone;
    return;
}

string RealTimeClock::getHMS8()
{
    setSecondsRealTime();
    strftime(buf, 10, "%H:%M:%S", localtime(&secRT));
    bufTmp= buf;
    return bufTmp;
}
string RealTimeClock::getHMS6()
{
    setSecondsRealTime();
    strftime(buf, 8, "%H%M%S", localtime(&secRT));
    bufTmp= buf;
    return bufTmp;
}

string RealTimeClock::getYMD8()
{
    setSecondsRealTime();
    strftime(buf, 10, "%y/%m/%d", localtime(&secRT));
    bufTmp= buf;
    return bufTmp;
}
string RealTimeClock::getYMD6()
{
    setSecondsRealTime();
    strftime(buf, 8, "%y%m%d", localtime(&secRT));
    bufTmp= buf;
    return bufTmp;
}


//bool RealTimeClock::setRealTime(string str, bool JPN)
bool RealTimeClock::setRealTime(string str)
{
    // now is in range of appropriate time.
    return setRealTime(A2I(str, 10));//, JPN);
}

//bool RealTimeClock::setRealTime(long now, bool JPN)
bool RealTimeClock::setRealTime(long now)
{
//    if(JPN)        now += 3600* 9;     // + JST 9hour.
    // 1,427,597,183（ISO 8601形式:   2015/03/29 02:46:23Z）
    // 2,147,483,647秒を経過した      (2038/01/19 03:14:07)
    if(!(1427597183<now && now<2147483600))
        return false;
    if(now == -1)
        return false;
    set_time(now);
    return true;
}

void RealTimeClock::setTimeZone(TimeZone tz)
{
    float hour= 0;
    if(tz==UTC || tz==GMT)
        hour= 0;
    if(tz == JST)
        hour= +9;
    if(tz == EST)
        hour= -5;
    if(tz == CST)
        hour= -6;
    if(tz == MST)
        hour= -7;
    if(tz == PST)
        hour= -8;
    this->setTimeZone(hour);
    return;
}
void RealTimeClock::setTimeZone(float hour)
{
    this->offsetTimeZone= (int)(hour* 3600+ 0.5);
    return;
}


// End of File