#pragma once

#include "mbed.h"
#include <string>

#include "StrLib.h"

/** Real Time Clock library
 *
 */
class RealTimeClock
{
public:
    /** Time Zone */
    enum TimeZone {
        UTC, GMT, JST, EST, CST, MST, PST
    };
    
    RealTimeClock(TimeZone tz= JST);
    RealTimeClock(float hour);

    /** @rtnval YY/MM/DD    */
    string getYMD8();

    /** @rtnval YYMMDD      */
    string getYMD6();

    /** @rtnval HH:MM:SS    */
    string getHMS8();

    /** @rtnval HHMMSS      */
    string getHMS6();

    /**
     * @param   'seconds' from 1970/01/01.
     * @rtnval  success(true), failure(false)
    */
    bool setRealTime(string str);

    /**
     * @param   seconds from 1970/01/01.
     * @rtnval  void
    */
    bool setRealTime(long now);
    
    void setTimeZone(TimeZone tz);
    void setTimeZone(float hour);

private:
    time_t secRT;               // secondsRealTime.  JST; 9hour
    int offsetTimeZone;          // [s]. internal TimeZone val.
    char buf[14];               // using for strftime()
    string bufTmp;              // return value
    void setSecondsRealTime();  // set secRt;

};