#include "RealTimeClock.h"

void RealTimeClock::setSecondsRealTime()
{
    secRT = time(NULL);
    return;
}

string RealTimeClock::getHMS8()
{
    setSecondsRealTime();
    strftime(buf, 10, "%H:%M:%S", localtime(&secRT));
    bufTmp= buf;
    return bufTmp;
}
string RealTimeClock::getHMS6()
{
    setSecondsRealTime();
    strftime(buf, 8, "%H%M%S", localtime(&secRT));
    bufTmp= buf;
    return bufTmp;
}

string RealTimeClock::getYMD8()
{
    setSecondsRealTime();
    strftime(buf, 10, "%y/%m/%d", localtime(&secRT));
    bufTmp= buf;
    return bufTmp;
}
string RealTimeClock::getYMD6()
{
    setSecondsRealTime();
    strftime(buf, 8, "%y%m%d", localtime(&secRT));
    bufTmp= buf;
    return bufTmp;
}


bool RealTimeClock::setRealTime(string str)
{
    long now= A2I(str, 10);
    now += 3600* 9;     // + JST 9hour.
    // 1,427,597,183（ISO 8601形式:   2015/03/29 02:46:23Z）
    // 2,147,483,647秒を経過した      (2038/01/19 03:14:07)
    if(!(1427597183<now && now<2147483600))
        return false;
    if(now == -1)
        return false;

    // now is in range of appropriate time.
    setRealTime(now);
    return true;
}

void RealTimeClock::setRealTime(long now)
{
    set_time(now);
    return;
}

// End of File