#pragma once

#include "mbed.h"
#include <string>

#include "StrLib.h"

/** Real Time Clock library
 * 
 */
class RealTimeClock
{
private:
    time_t secRT;               // secondsRealTime.  JST; 9hour
    char buf[14];               // using for strftime()
    string bufTmp;              // return value
    void setSecondsRealTime();  // set secRt;

public:
    /** @rtnval YY/MM/DD    */
    string getYMD8();

    /** @rtnval YYMMDD      */
    string getYMD6();

    /** @rtnval HH:MM:SS    */
    string getHMS8();

    /** @rtnval HHMMSS      */
    string getHMS6();

    /**
     * @param   seconds from 1970/01/01.
     * @rtnval  success(true), failure(false)
    */
    bool setRealTime(string str);

    /**
     * @param   seconds from 1970/01/01.
     * @rtnval  void
    */
    void setRealTime(long now);

};