/**     RN41/42 is Bluetooth module. RN41 is calss 1, RN42 is class 2.
 *  RN42 refer to http://akizukidenshi.com/catalog/g/gM-07612/ .
 */

/*
 * cmdで送る改行コードは、CRのみ。LFは文字として認識されるので?となる。
 * RN41 Returns (default); AOK(valid cmd), ERR(invalid cmod), ?(unrecongnized cmd).

%を付ける初期化処理必須

*/

/**
 @code
 #include "mbed.h"
#include <string>
#include "RN41.h"
RN41 rn41(p13, p14, 9600);
DigitalOut led[]= {LED1, LED2, LED3, LED4};
void connectRN41(string tmpAddr);
int main()
{
    while(true) {
        led[0]= !led[0];
        connectRN41("target BT address");
        rn41.sendLine("test");
        wait_ms(100);
        printf(rn41.getLine().c_str());
        if(rn41.disconnect())
            printf("disconnect");
        wait(5.0);
    }
}
void connectRN41(string tmpAddr)
{
    printf("Connect to: %s.\r\n", tmpAddr);
    int status= rn41.connect(tmpAddr);
    if(status == RN41::OK)                      printf("OK, Connect.");
    else if(status == RN41::ERR_AddrUnder12)    printf("NG, Connect. Under12 Addr.");
    else if(status == RN41::ERR_AddrOver12)     printf("NG, Connect. Over12 Addr.");
    else if(status == RN41::ERR_EnterCmdMode)   printf("Error, failed in to enter Cmd-mode.");
    else if(status == RN41::ERR_Disconnect)     printf("Error, failed in DisConnect.");
    else if(status == RN41::ERR_Connect)        printf("Error, Connect.");
    else if(status == RN41::FAIL_Connect)       printf("Fail, Connect.");
    else if(status == RN41::ERR_Timeout )       printf("Error, TimeOut.");
    else                                        printf("Error Connection: %d.",status);
    return;
}
 @endcode
*/

#pragma once

#include "mbed.h"
#include "StrLib.h"
#include "myTimer.h"
#include "RingBuffer.h"

/**     Bluetooth module RN41/42 control class.
 *
 */
class RN41
{
public:

//    static const int
    static const int NG, OK;//=                  1;
    static const int ERR_AddrUnder12, ERR_AddrOver12, ERR_Connect, FAIL_Connect;
    static const int ERR_EnterCmdMode, ERR_Disconnect, ERR_Timeout;

//    static const int None, Odd, Even;
    static const int ERR_NameSize;

    /** Create Serial port to RN41. for LPC1768
     *  @param TX, RX;              Serial port.
     *  @param baud-rate;                Baud rate (bps).
     *  @param bit, parity, stop;   Default: 1Stopbit, NoneParity, 1StopBit.
     *                              -- parity select; N(None), O(Odd), E(Even).
     *  @param CRLN;                true -> CR&LN (\r\n), false -> CR only (\r).
     */
    RN41(PinName TX, PinName RX, int baudrate, int bit=8, int parity=SerialBase::None, int stop=1, bool CRLN=true);

    string read();

    /**
     *      RxStrのCRまでを返す。
     */
    string getLine();

    /**
     *
     */
    void sendCMD( string str, bool addCR=true);
    void sendLine(string str, bool addCR=true);


    int setDev_Name(string str, bool usingAddr=true);
    int setDev_UART(int baud, int bit=8, int parity=SerialBase::None, int stop=1);


// Command to RN41
    bool enterCMD();
    int connect(string addr);     // 必ず、Checkを呼ぶこと。2-5sかかるよ
    bool disconnect();
    bool reboot();

private:
    RawSerial rn41;
    string cr;
    string rxStr, rxStrStored;      // 内部バッファ。read()での保管用と、GetLineまでの保管用。
    RingBuffer ringBuf;             // rxIRQ用の循環バッファ256kB。
//    string rxStrStored;      // 内部バッファ。read()での保管用と、GetLineまでの保管用。
    // 9,600bpsなら、1文字受信に833us必要。安全率1.3として13ループさせるため、待ち時間us/0.1文字とする。
//    int usWait4readBuf;       // -> attach
//    Timer timerLocal;
    myTimer timer;

    static const int findCmp1, findCmp2, findCmp12;

    struct bool2 {
        bool b1, b2;
    };
    struct b2i2 {
        bool b1, b2;
        int i1, i2;
    };

    /** check reply from RN41.
     *  @Param  cmp; string to compare
     *  @Param  timeout; timeout [ms]
     *  @return bool; true: ok, false: NG.
     */
//    int chkReply(string cmp1, int timeout, string cmp2="");
//    bool chkReply_woCR(string cmp, int timeout);
    bool2 chkReply(string cmp1, int timeout, string cmp2= "", bool wCR= true);
    bool2 chkReply_process_wCR( string cmp1, string cmp2);
    bool2 chkReply_process_woCR(string cmp1, string cmp2, bool wCR);
    b2i2 chkReply_find(string trg, string cmp1, string cmp2);


    /** Just copy to rxStr from Buffer. */
    void _read();
    void _readIrq();
};

// EOF