/**
 *
 * 12bit Resolution. Dual-channel and Rail-to-Rail Output.
 * SPI Interface with 20MHz. Latching Dual output with LDAC.
 * Seting time of 4.5us. Selectable 1x or 2x Gain.
 * Vdd supplied 2.7 to 5.5V, Vref < Vdd.
 * LDAC setup time: 40ns, pulse: 100ns.
 */

/** @code

 * @endcode
 */
 
#pragma once

#include "mbed.h"

class MCP4922{
public:
    // With LatchPin
    /** Constructor; 
     *  @param mosi, sck, cs, latch
    */
    MCP4922(PinName mosi, PinName sck, PinName _cs, PinName _latch);
    /** Constructor; 
     *  @param spi's ptr, cs, latch
    */
    MCP4922(SPI &_spi, PinName _cs, PinName _latch);
    
    // W/O LatchPin
    /** Constructor; 
     *  @param mosi, sck, cs
    */
    MCP4922(PinName mosi, PinName sck, PinName _cs);
    /** Constructor; 
     *  @param spi's ptr, cs
    */
    MCP4922(SPI &_spi, PinName _cs);
    ~MCP4922();
//  ******************** enable printf() future of C-language. ****************
    
    enum ERR{
        SUCCESS, ERR_HZ, ERR_GAIN, ERR_VAL
    };
    enum CH{
        chA, chB
    };
    
    /** ESENTIAL FUNC.; Initialize Configlation.
     *
     * @param hz; freq. of SPI.
     * @param gainA/B; output gain select 1x|2x. Vref*gain.
     * @param bufA/B; Normally off(false); Buffered= true;
     */
    MCP4922::ERR init(int hz= 20000000, int gainA= 1, int gainB= 1, 
        bool bufA= false, bool bufB= false);
    
    /** Set Value
     * @param A, B; 0-4095 (12bit)
     */
    void setVal(int valA, int valB);
    
    /** Set Value
     * @param A, B; 0.0f-1.0f (12bit)
     */
    void setVal(float valA, float valB);
    
    /** Set Value
     * @param val; 0-4095 (12bit)
     */
    void setVal(CH ch, int val);
    
    /** Set Value
     * @param val; 0.0f-1.0f (12bit)
     */
    void setVal(CH ch, float val);

    /** Write ALL with update-output(latch off).
     */
    void write();
    
    /** Write
     */
    void write(CH ch, bool latch= true);
    
    /** Update
     */
    void update();

private:
    // using i2c
    SPI *p_spi;
    SPI &spi;
    DigitalOut cs;
    DigitalOut latch;
    
    bool _bufA, _bufB, _gainA, _gainB;
  
    uint16_t  valA, valB;
//    bitset<16> valA(0);  // 16bit 2Byte.
//    bitset<16> valB(0);  // 16bit 2Byte.
    
    void _write(uint16_t val);
    
    bool useLPin;
};

// EOF