#include "MCP4922.h"

// **** Constructor & destructor ****
// With LathPin
MCP4922::MCP4922(PinName mosi, PinName sck, PinName _cs, PinName _latch)
    : p_spi(new SPI(mosi, NC, sck)), spi(*p_spi), cs(_cs, 1), latch(_latch, 1)
{
    useLPin= true;  //Latch pin
}
MCP4922::MCP4922(SPI &_spi, PinName _cs, PinName _latch)
    : p_spi(NULL), spi(_spi), cs(_cs, 1), latch(_latch, 1)
{
    useLPin= true;  //Latch pin
}
// W/O LatchPin
MCP4922::MCP4922(PinName mosi, PinName sck, PinName _cs)
    : p_spi(new SPI(mosi, NC, sck)), spi(*p_spi), cs(_cs, 1), latch(NC)
{
    useLPin= false;  //Latch pin
}
MCP4922::MCP4922(SPI &_spi, PinName _cs)
    : p_spi(NULL), spi(_spi), cs(_cs, 1), latch(NC)
{
    useLPin= false;  //Latch pin
}
MCP4922::~MCP4922()
{
    if(p_spi != NULL)
        delete p_spi;
}

// **** INIT Config ****
MCP4922::ERR MCP4922::init(int hz, int gainA, int gainB, bool bufA, bool bufB)
{
    // valA/B init.
//    valA= 0x0000;   // bit15 : 0
//    valB= 0x8000;   // bit15 : 1

    if(hz <= 0 || 20000000 < hz)
        return ERR_HZ;
    spi.frequency(hz);
    spi.format(16);  // 16bit, mode=0

    _bufA= bufA;
    _bufB= bufB;
//    valA |= (_bufA << 14);  // if ture; |= 0x0400
//    valB |= (_bufB << 14);

    if(!(gainA==1 || gainA==2))
        return ERR_GAIN;
    if(!(gainB==1 || gainB==2))
        return ERR_GAIN;
    _gainA= (gainA==1) ? true : false;  // false=0: 2x
    _gainB= (gainB==1) ? true : false;  // false=0: 2x
//    valA |= (_gainA << 13);
//    valB |= (_gainB << 13);

    // bit12; ShatDown=0
//    valA |= (1 << 12);
//    valB |= (1 << 12);
    valA= 0x0000+ (_bufA << 14)+ (_gainA << 13)+ 0x1000;
    valB= 0x8000+ (_bufB << 14)+ (_gainB << 13)+ 0x1000;

    return SUCCESS;
}


void MCP4922::setVal(int valA, int valB)
{
    this->setVal(chA, valA);
    this->setVal(chB, valB);
    this->write();
    return;
}

void MCP4922::setVal(float valA, float valB)
{
    int a= (int)(valA*4095.0+ 0.5);
    int b= (int)(valB*4095.0+ 0.5);
    this->setVal(a, b);
    return;
}

void MCP4922::setVal(CH ch, int val)
{
    /*    if(val < 0 || 4096 < val)
            return ERR_VAL;*/
    if(val < 0)
        val= 0;
    if(4096 < val)
        val= 4095;

    uint16_t tmp= val;    // bit0-bit11; 1B+4b
    if(ch == chA) {
        valA &= 0xf000;
        valA |= tmp;
    } else {
        valB &= 0xf000;
        valB |= tmp;
    }
    return;
}

void MCP4922::setVal(CH ch, float val)
{
    /*    if(val < 0.0 || 1.0 < val)
            return ERR_VAL;*/
    if(val < 0.0)
        val= 0.0;
    if(1.0 < val)
        val= 1.0;

    this->setVal(ch, (int)(val*4095.0+ 0.5));
    return;
}

void MCP4922::write()
{
    this->_write(valA);
    this->_write(valB);
    this->update();
    return;
}

void MCP4922::write(CH ch, bool latch)
{
    uint16_t val;
    if(ch == chA)
        val= valA;
    else
        val= valB;
    _write(val);

    if(!latch)
        update();

    return;
}

void MCP4922::_write(uint16_t val)
{
    latch= 1;
    cs= 0;
    spi.write(val);
    cs= 1;
    return;
}

void MCP4922::update()
{
    if(latch == NULL)
        return;
    latch= 0;
}

// EOF