#include "LED7segX4.h"

LED7segX4::LED7segX4(BusOut &portDig, BusOut &portSeg)
    : _portDig(portDig), _portSeg(portSeg)
{
    return;
}

LED7segX4::~LED7segX4()
{
    return;   
}


void LED7segX4::init(bool revDig, bool revSeg, int timePeriod, int duty)
{
    for(int i= 0; i < 5; i++)
        _seg7[i]= NULL;

    init_def7seg();

    this->setReverse(revDig, revSeg);
    
    this->setPWM(timePeriod, duty);
    
    return;
}

void LED7segX4::setReverse(bool dig, bool seg)
{
    _revDig= dig;
    _revSeg= seg;
    
    return;
}


void LED7segX4::init_def7seg()
{
    _def7seg[0]= 0x3F;   // 0
    _def7seg[1]= 0x06;
    _def7seg[2]= 0x5B;
    _def7seg[3]= 0x4F;
    _def7seg[4]= 0x66;
    _def7seg[5]= 0x6D;
    _def7seg[6]= 0x7D;
    _def7seg[7]= 0x27;
    _def7seg[8]= 0x7F;
    _def7seg[9]= 0x6F;   // 9
    _def7seg[10]= 0x77;  // A
    _def7seg[11]= 0x7C;  // b
    _def7seg[12]= 0x39;  // C
    _def7seg[13]= 0x5E;  // d
    _def7seg[14]= 0x79;  // E
    _def7seg[15]= 0x71;  // F
    _def7seg[16]= 0x00;
    
    return;
}

void LED7segX4::OnSet()
{
    static char tmp;
    
    if(++_currentDigit >= 4)
        _currentDigit= 0;
    
    // ** SELECT DIGIT.
    tmp= 0b1000 >> _currentDigit;
    if(_revDig)
        tmp ^= 0xff;
    _portDig = tmp;   // set BusOut
    
    
    // ** SET current PATTERN of 7SEG.
    tmp= _seg7[_currentDigit];      // 0-9, a-f, 16(NULL)
    tmp= _def7seg[tmp];             // ex. 6:0x7D
    
    // -- set DP
    if(_dp & (0b0001 << _currentDigit) )
        tmp |= 0x80;    // DP: b7
    
    if(_revSeg)
        tmp ^= 0xff;
    _portSeg= tmp;      // set Bus
    
    
    // *** Atach TimeOut for Modulated Brightness ***
    if(_dutySec != -1)
        timeout.attach(this, &LED7segX4::OffSet, _dutySec);
    
    return;
}

void LED7segX4::OffSet()
{
    static char tmp;
    
    tmp= 0b0000;
    if(_revDig)
        tmp ^= 0xff;
    _portDig = tmp;   // set BusOut
    
    tmp= 0x00;
    if(_revSeg)
        tmp= 0xff;
    _portSeg= tmp;      // set BusOut
    
    return;
}



// **********************************************
//          Public Interface Set Function
// **********************************************
void LED7segX4::set7seg(char chr[])
{
    // 0~3 REVERCE
    for(int i= 0; i < 4; i++)
        _seg7[i]= chr[3-i];
    
    return;
}

void LED7segX4::setDP(char chr)
{
    _dp= chr;
    return;
}

void LED7segX4::setPWM(int timePeriod, int duty)
{
    if(duty <= 0){
        ticker.detach();        // detach
        this->OffSet();
        return;
    }
    
    _dutySec= timePeriod* 1e-6* (duty / 100.0);
    if(duty >= 100)
        _dutySec= -1;

    ticker.attach(this, &LED7segX4::OnSet, timePeriod* 1e-6);
    
    return;
}


// EOF