#pragma once

/** Detected Iteration Above Threshold in Unit Time.
 *  Check if Frequency (iteration count in Unit time) above Threshold.
 *
 *  CATION. max interval is 0xfff0: 65,520ms.
 *          max iter threshold is 0xffff.
 *              (threfore, using 131KB with span[0xffff].)
 */
/** Sample code
#include "mbed.h"
#include "DetectFreqAboveTH.h"

DigitalOut led1(LED1);
DigitalOut led4(LED4);

DetectFreqAboveTH chkErrIter(5000, 100);

int main()
{
   while(1) {
       led1= !led1;
       if(chkErrIter.chkAbove()) {
           led4= !led4;
           wait_ms(5100);
       }
       wait_ms(20);
   }
}
*/

#include "mbed.h"
#include "myTimer.h"

class DetectFreqAboveTH
{
public:
    DetectFreqAboveTH(int time_ms, int iter);
    ~DetectFreqAboveTH();

    bool chkAbove();

private:
    unsigned short id, iterThreshold, *span;   // circular buffer
    unsigned int unitTime;
// 16bit: 0xFFFF

    myTimer timer;
};