#include "DetectFreqAboveTH.h"

//extern DigitalOut led[];

DetectFreqAboveTH::DetectFreqAboveTH(int time_ms, int iter)
{
//    led[0]= 1;
    unitTime= time_ms;
    iterThreshold= iter;
    span= new unsigned short[iter];
//init
    for(id= 0; id < iterThreshold; id++)
        span[id]= 0xffff;
    this->timer.start(true);
    id= 0;
//    led[1]= 1;
}

DetectFreqAboveTH::~DetectFreqAboveTH()
{
    delete [] span;
}


bool DetectFreqAboveTH::chkAbove()
{
    int tmpSpan= this->timer.read_ms(); //reset

    if(tmpSpan > 0xfff0)    // 65,520ms.
        tmpSpan= 0xffff;

    span[id]= tmpSpan;
    id++;
    id %= iterThreshold;
    if(tmpSpan == 0xffff)
        return false;

    unsigned int sum= 0, tmp;
    for(int i= 0; i < iterThreshold; i++) {
        tmp= span[i];
        if(tmp == 0xffff)   // under threshold iter count.
            return false;
        sum += tmp;
        if(sum >= unitTime)
            return false;
    }
    // sumが単位時間未満なので、発生回数（/単位時間）は閾値以上。
    return true;
}

// EOF