/**  ATP3011 is Text Speech LSI by AquesTalk.
 * This librarry supports I2C interface and "printf()" C format.
 * If ATP3011 talk number or alphabet you select printf(), 
 * otherwise, you have to use speech().
 * When you use printf(), the string must have "\n".
 *
 * @code.
 * I2C i2c(p9, p10);
 * ATP3011 talk(i2c);
 * //or ATP3011 talk(p9, p10);
 * talk.speech("#K");
 * talk.speech("tesu'to.");
 * talk.printf("denwaba'ngo-wa,<NUM VAL=0%d-%d-%d>,desu'.\n", 120, 123, 456);
 * char *chr= "abc123";
 * talk.printf("nyu-ryoku wa <ALPHA VAL=%s> de'su.\n", chr);
 * float dist= 3.14;
 * int lateTime= 7;
 * talk.printf("konosaki;<NUMK VAL=%.2f COUNTER=kiro>/ju-taichu-.tu-kadi'kann wa;<NUMK VAL=%d COUNTER=funn> de'su.\n", dist, lateTime);
 * @endcode
 */
 
#pragma once

#include "mbed.h"

#define MAX_CHAR    127
 
class ATP3011 : public Stream{
public:
    ATP3011(PinName sda, PinName scl, char addr = 0x2E<<1);
    ATP3011(I2C &_i2c, char addr = 0x2E<<1);
    
    /** Return message.
     */
    static const int SUCCESS, BUSY, READY, TIME_OUT;
    static const int ERR_I2C, ERR_OTHER, ERR_TooLeng;
    
    // if you send number or alphabet, you can use printf().
    // oterwise, you have to use speech().
    
    /** speech message.
     *  @param msg; if string, it's necessaly ".".
     *  @param timeout; if 0 ms, func wait to ready without timeout.
     *  @return; above Return message.
     */
    int speech(const char *msg, int timeout_ms= 0);
    
    /** check Busy.
     *  @return;    READY, BUSY, ERR_I2C, ERR_OTHER.
     */
    int chkBusy();
    
    void init(char _addr);
    
    
private:
    char addr;
    I2C i2c;
    Timer timer;    // if send or read to ATP3011, timer is reseted.
    
    char chr[MAX_CHAR];
    int send(int timeout_ms= 0);
    
    // virtual func for printf() in Stream-class.
    virtual int _putc(int val);
    virtual int _getc();
    
    void initChar();
};

// EOF