#include "ATP3011.h"

const int ATP3011::SUCCESS=     10;
const int ATP3011::READY=       11;
const int ATP3011::BUSY=        12;
const int ATP3011::TIME_OUT=    13;
const int ATP3011::ERR_I2C=     20;
const int ATP3011::ERR_OTHER=   21;
const int ATP3011::ERR_TooLeng= 22;

ATP3011::ATP3011(PinName sda, PinName scl, char _addr)
    : i2c(sda, scl)
{
    this->init(_addr);
}

ATP3011::ATP3011(I2C &_i2c, char _addr)
    : i2c(_i2c)
{
    this->init(_addr);
}

void ATP3011::init(char _addr)
{
    this->addr= _addr;
    this->timer.reset();
    this->timer.start();
    this->initChar();
    return;
}

void ATP3011::initChar()
{
    for(int i= 0; i < MAX_CHAR; i++)
        this->chr[i]= 0x00;
    return;
}

int ATP3011::_putc(int val)     // for printf()
{
    int idx= strlen(chr);
    if(idx > MAX_CHAR-4) {
        this->initChar();
        return val;
    }

    if(val == '\n') {
        chr[idx]= '\r';
        chr[idx+1]= 0x00;
        this->send();
    } else {
        chr[idx]= val;
    }

    return val;
}

int ATP3011::speech(const char *msg, int timeout_ms)
{
    if(strlen(msg) > MAX_CHAR-4)
        return this->ERR_TooLeng;

    // copy message.
    int idx= 0;
    for(idx= 0; idx < MAX_CHAR-2; idx++) {
        chr[idx]= msg[idx];
        if(msg[idx] == 0x00)
            break;
    }

    // string adj.    // there, send[idx] == 0x00
//    if(send[idx-1] == '\r')       char: 0 ~ idx-1 -> length= idx
    if(chr[idx-1] != '\r') {   // ex. "."
        chr[idx]= '\r';
        chr[idx+1]= 0x00;
    }

    int status= this->send(timeout_ms);
    return status;
}

int ATP3011::send(int timeout_ms)
{
    int status;
    Timer tmpTimer;
    tmpTimer.reset();
    tmpTimer.start();
    while(true) {
        status= this->chkBusy();
        if(status == this->ERR_I2C)
            return this->ERR_I2C;
        if(status == this->READY)
            break;
        // loop; busy or other response.
        if(timeout_ms!=0 && tmpTimer.read_ms()>timeout_ms)
            return this->TIME_OUT;
    }

    status= i2c.write(addr, chr, strlen(chr));
    this->initChar();
    timer.reset();
    if(status != 0)
        return this->ERR_I2C;
    return this->SUCCESS;
}


int ATP3011::chkBusy()
{
    int wait_time= 10- timer.read_ms();
    if(wait_time > 0)
        wait_ms(wait_time);

    char c= 0x00;
    int status= i2c.read(addr+0x01, &c, 1);
    this->timer.reset();
    if(status != 0)
        return this->ERR_I2C;
    if(c == '>')
        return this->READY;
    if(c=='*' || c==0xff)
        return this->BUSY;

    return this->ERR_OTHER;
}


int ATP3011::_getc()
{
    return -1;
}


// EOF