/**
 *  LCD AQM1602 library, refer to http://akizukidenshi.com/catalog/g/gP-08779/.
 *  16 chars x 2 lines.
 *  I select 20k ohm as pullup resistor.
 */

/** @code
 * #include "mbed.h"
 * #include "AQM1602.h"
 * 
 * I2C i2c(p28, p27);
 * AQM1602 lcd(i2c);    // if 5.0v supply, (i2c, false);
 * DigitalOut led[]= {LED1, LED2, LED3, LED4};
 * 
 * int main()
 * {
 *     lcd.init();
 *     int iter= 0;
 *     while(true) {
 *         led[0] = !led[0];
 *         lcd.printf("iter: %5.5d.\r\n", iter);
 *         wait(1.0f);
 *         if(iter%10 == 0)    // 10s
 *             lcd.clear();
 *         iter++;
 *     }
 * }
 * @endcode
 */
 
#pragma once

#include "mbed.h"

class AQM1602 : public Stream{
public:
    AQM1602(PinName sda, PinName scl, bool pw3v3= true, char address= 0x7c);
    AQM1602(I2C &_i2c, bool pw3v3= true, char address= 0x7c);
    ~AQM1602();
//  ******************** enable printf() future of C-language. ****************
    
    /** Initialize
     */
    void init();

    /** Clear Display.
     */
    void clear();
    
    /** CR, LF
     */
    void cr();
    void lf();
    
    /** Set Position of char.
     *  @param col: column, row: rows.
     */
    void locate(int col, int row);
    
    /** Set Contrast.
     *  @param val; 64steps, 0x00 ~ 0x3f. Contrast increas as the value.
     *              default: 0x23.
     */
    void setContrast(char val, bool ctrlIS= true);

    /** Set Display flag.
     * @parm Enable Display, Cursor turned on, Cursor Blink.
     */
    void setDispFlag(bool disp= true, bool cursor= true, bool blink= true);

private:
    // using i2c
    I2C *p_i2c;
    I2C &i2c;
    char addr;          // i2c Addr.
    char buf[3];        // i2c to write char space
    int wait4cmd;       // waiting time span for sending command.
    
//    char valContrast;
    int col, row;  // column, row of the LCD panel.
    bool vdd3v3;
    char contrast;
    
    void setPwContrast(bool ctrlIS= true);
    
    bool cmd(char chr);
    
    // virtual func for printf() in Stream-class.
    virtual int _putc(int value);
    virtual int _getc();    // return -1.
    
    void setIS();
    void clearIS();
};

// EOF