#include "AQM1602.h"

AQM1602::AQM1602(PinName sda, PinName scl, bool pw3v3, char address)
    : p_i2c(new I2C(sda, scl)), i2c(*p_i2c), addr(address), vdd3v3(pw3v3)
{
    init();
}
AQM1602::AQM1602(I2C &_i2c, bool pw3v3, char address)
    : p_i2c(NULL), i2c(_i2c), addr(address), vdd3v3(pw3v3)
{
    init();
}
AQM1602::~AQM1602()
{
    if(p_i2c != NULL)
        delete p_i2c;
}

bool AQM1602::cmd(char chr)
{
    buf[0]= 0x00;
    buf[1]= chr;
    // if write success:0, other: err code.
    int status= i2c.write(addr, buf, 2);
    wait_ms(3);

    if(status == 0)
        return true;
    else
        return false;
}

int AQM1602::_putc(int val)     // for printf()
{
    if (val == '\r') {
        this->cr();
    } else if (val == '\n') {
        this->lf();
    } else {
        locate(col, row);
        buf[0]= 0x40;
        buf[1]= val;
        i2c.write(addr, buf, 2);

        col++;
        if (col >= 16) {
            this->cr();
            this->lf();
        }
    }
    wait_ms(1);
    return val;
}

// for "Stream"
int AQM1602::_getc()
{
    return -1;
}

void AQM1602::locate(int _col, int _row)
{
    col= _col;
    row= _row;
    cmd(0x80 + row * 0x40 + col);
    return;
}

void AQM1602::init()
{
    col= row= 0;
    buf[0]= 0x00;
    buf[1]= 0x00;
    buf[2]= 0x00;
    wait4cmd= 3;
//    valContrast= 0x23;

    wait_ms(wait4cmd);
    // Function set = 0x38; 0b0011 1000
    // Function set = 0x39; 0b0011 1001
    this->clearIS();
    this->setIS();

    // ** must be IS=1. **
    // Internal OSC frequency = 0x14; 0b0001 0100
    this->cmd(0x14);
    wait_ms(wait4cmd);

    // Power/ICON/Contrast control = 0x56; 0b0101 0110
    // Contrast set = 0x70; 0b0111 0011
    this->setContrast(0x23, false);

    // Follower control = 0x6C; 0b0110 1100
    this->cmd(0x6C);
    wait_ms(220);

    this->clearIS();
    this->setDispFlag(true, true, true);
    this->clear();

    // Function set = 0x38; 0b0011 1000
    // Display ON/OFF control = 0x0C; 0b 0000 1DCB
    // Clear Display = 0x01; 0b 0000 0001

    return;
}

void AQM1602::setContrast(char val, bool ctrlIS)
{
// C5,C4,C3,C2,C1,C0 can only be set when internal follower is used (OPF1=0,OPF2=0).
// They can more precisely adjust the input reference voltage of V0 generator.
// The details please refer to the supply voltage for LCD driver.

    if(val > 0x3f)// || val < 0x00)
        return;

    contrast= val;
    setPwContrast(ctrlIS);

    return;
}

void AQM1602::setPwContrast(bool ctrlIS)
{
// C5,C4,C3,C2,C1,C0 can only be set when internal follower is used (OPF1=0,OPF2=0).
// They can more precisely adjust the input reference voltage of V0 generator.
// The details please refer to the supply voltage for LCD driver.

    // Cmd of Contrast-setting must be setted IS.
    if(ctrlIS)
        this->setIS();

    // 0b 0101 0*++     // PW, C5, C4
    char val= 0x50;
    if(vdd3v3)      // set Booster circuit.
        val += 0x04;
    val += (contrast>>4);
    this->cmd(val);
//    this->cmd(0x54+ (contrast>>4));
    wait_ms(wait4cmd);

    // 0b 0111 ++++     // C3, C2, C1, C0
    this->cmd(0x70+ (contrast&0x0f));
    wait_ms(wait4cmd);

    if(ctrlIS)
        this->clearIS();

    wait_ms(wait4cmd);
    return;
}

void AQM1602::clear()
{
    this->cmd(0x01);
    locate(0, 0);
    wait_ms(wait4cmd);
    return;
}


void AQM1602::cr()
{
    col = 0;
    locate(col, row);
    return;

}

void AQM1602::lf()
{
    row++;
    row &= 1;
    int _col= col;
    for(int i= 0; i < 16; i++) {
        locate(i, row);
        buf[0]= 0x40;
        buf[1]= ' ';
        i2c.write(addr, buf, 2);
    }
    locate(_col, row);
    return;
}

void AQM1602::setDispFlag(bool disp, bool cursor, bool blink)
{
    // set On/Off. b3=1, b2:Disp, b1:Cursor, b0:blink.
    char tmp=  0x08;
    if(disp)
        tmp += 0x04;
    if(cursor)
        tmp += 0x02;
    if(blink)
        tmp += 0x01;
    this->cmd(tmp);
    this->cmd(0x01);    //Clear Disp.
    wait_ms(wait4cmd);
    return;
}

// ******************** FUNCTION SET **********************
// IS func-set -> 0b 001L NH0I
//          L: Interface data Length. 1:8bit-bus, 0:4bit.
//          N: Display line Number. 1: 2 lines, 0: 1 line.
//          H: Double Hight font. if H=1 and N=1, 5x16 dots.
//              0: Normal (5x8 dots).
//          I: Normal / Extentsion Instruction. 1: Ext Instruction, 0: Norm.
void AQM1602::setIS()
{
    this->cmd(0x39);
    wait_ms(wait4cmd);
    return;
}
void AQM1602::clearIS()
{
    this->cmd(0x38);
    wait_ms(wait4cmd);
    return;
}

// EOF