/*
 * This example shows how to "delay" an action yet still
 * have the system response to other tasks or processes.
 *
 * Note, f1() and f2() do the same thing. They are just 
 * coded in different ways to show how versitile the Ton
 * object is.
 *
 * Note how setting a Ton to non-zero starts the timer.
 * Reading the value of a Ton object will return zero if
 * the timer has not yet been reached. It will return a
 * non-zero value (1) if the timeout value is reached.
 *
 * Tons can operate in one of two modes. The default mode
 * is Ton::InputResets and what this means is setting a Ton
 * to zero will reset the interval timer back to it's default
 * value thus forcing a complete retime next time a Ton is 
 * asserted.
 * 
 * The other mode, Ton::InputPauses doesn't reset the internal
 * counter, it just halts it. So when a future event starts the
 * timer again it doesn't time the entire timer value but the
 * remaining value left since it's last assertion.
 * 
 * The mode is set when created, eg:-
 * Ton t1(2000, Ton::InputResets); // (default)
 * Ton t1(2000, Ton::InputPauses); // (pause mode)
 */
#include "mbed.h"
#include "Ton.h"

DigitalIn ip1(p19);
DigitalIn ip2(p20);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Ton t1(2000);
Ton t2(2000);

void f1(void) {
    t1 = ip1;
    led1 = t1;
}

void f2(void) {
    t2 = ip2;
    if (t2) {
        led2 = 1;
    }
    else {
        led2 = 0;
    }
}

int main() {
    while(1) {
        f1();
        f2();
    }
}
