/* 
 * This example DOES NOT use a Ton timer. It shows how
 * beginners often "abuse" wait() to wait for a period
 * of time before actioning something. As shown here we
 * delay the switching on an LED after an input is asserted.
 *
 * The problem is that they "interfer" with each other. Using
 * wait() to wait around causes the entire system to hold up
 * waiting some period of time. As you can see, this holds up
 * the main() systems while(1) loop preventing any other task
 * or process from being performed.
 *
 * THIS IS AN EXAMPLE OF HOW NOT TO DO IT!
 *
 * To see how the Ton object can fix this issue see example2.h
 */
#include "mbed.h"

DigitalIn ip1(p19);
DigitalIn ip2(p20);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

void f1(void) {
    if (ip1) {
        wait(2);
        led1 = 1;
    }
    else {
        led1 = 0;
    }
}

void f2(void) {
    if (ip2) {
        wait(2);
        led2 = 1;
    }
    else {
        led2 = 0;
    }
}

int main() {
    while(1) {
        f1(); // Do process f1()
        f2(); // Do process f2()
    }
}
