/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#ifndef AJK_TICKERSSYS_H
#define AJK_TICKERSSYS_H

#include "mbed.h"
#include "Tickers.h"
#include <list>

namespace AjK {

class Ticker0;

// Ticker0 controller.
class Ticker0Sys {
protected:
    list<Ticker0 *> tickers;
    
public:
    void init(void);
    Ticker0Sys();
    void isr(void);    
    void addTicker(Ticker0 *t);
    void delTicker(Ticker0 *t);        
};

class Ticker1;

// Ticker1 controller.
class Ticker1Sys {
protected:
    list<Ticker1 *> tickers;
    
public:
    void init(void);
    Ticker1Sys();
    void isr(void);    
    void addTicker(Ticker1 *t);
    void delTicker(Ticker1 *t);        
};

class Ticker2;

// Ticker2 controller.
class Ticker2Sys {
protected:
    list<Ticker2 *> tickers;
    
public:
    void init(void);
    Ticker2Sys();
    void isr(void);    
    void addTicker(Ticker2 *t);    
    void delTicker(Ticker2 *t);    
};

class Ticker4;

// TickerR controller.
class TickerRSys {
protected:
    list<Ticker4 *> tickers;
    
public:
    void init(void);
    TickerRSys();
    void isr(void);    
    void addTicker(Ticker4 *t);    
    void delTicker(Ticker4 *t);    
};

}; // namespace AjK ends.

using namespace AjK;

#endif
