/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

// Mimic Mbed's Ticker class but using RIT
// (note, only goes to milliseconds level not microseconds!)

#include "TickersSys.h"

namespace AjK {

// Create a Ticker1 controller.
TickerRSys _tickerRSys;

// Nice and simple ISR, just call the class standard handler.
extern "C" void RIT_IRQHandler(void) __irq 
{
    _tickerRSys.isr();    
}

TickerRSys::TickerRSys(void)
{    
    LPC_SC->PCONP |= (1UL << 16);   // RIT On
    
    switch ((LPC_SC->PCLKSEL1 >> 26) & 0x3) {
        case 0: LPC_RIT->RICOMPVAL = (96000000L / 4 / 1000); break; /* CCLK / 4 */
        case 1: LPC_RIT->RICOMPVAL = (96000000L / 1 / 1000); break; /* CCLK / 1 */
        case 2: LPC_RIT->RICOMPVAL = (96000000L / 2 / 1000); break; /* CCLK / 2 */
        case 3: LPC_RIT->RICOMPVAL = (96000000L / 8 / 1000); break; /* CCLK / 8 */
    }
    
    NVIC_EnableIRQ(RIT_IRQn);
    LPC_RIT->RICTRL     = 0x0000000A;
}

void 
TickerRSys::addTicker(Ticker4 *t)
{
    tickers.push_back(t);   
}

void 
TickerRSys::delTicker(Ticker4 *t)
{
    for (list<Ticker4 *>::iterator itor = tickers.begin(); itor !=  tickers.end(); ++itor) {
        if ((*itor) == t) {
            itor = tickers.erase(itor);
            return;
        }
    }
}

void 
TickerRSys::isr(void)
{
    LPC_RIT->RICTRL |= 0x1; /* Dismiss the IRQ. */
    
    if (tickers.empty()) return;
    
    for (list<Ticker4 *>::iterator itor = tickers.begin(); itor !=  tickers.end(); ++itor) {
        (*itor)->tick();
    }
    
}    
}; // namespace AjK ends.
