/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#ifndef AJK_TICKERS_H
#define AJK_TICKERS_H

#include "mbed.h"
#include "TickersSys.h"
#include <list>

namespace AjK {

// Mimic Mbed's Ticker class but using TIMER1 
// (note, only goes to milliseconds level not microseconds!)

class Ticker0Sys;
extern Ticker0Sys _ticker0Sys;

class Ticker0 {
protected:
    FunctionPointer callback;
    uint32_t counter;
    uint32_t reload;
public:
    Ticker0();
    ~Ticker0();
    void tick(void);
    
    void detach(void) {        
        callback.attach();
    }
    void attach(void (*fptr)(void), double d) {
        counter = reload = (uint32_t)( d * 1000.0 );
        callback.attach(fptr);
    }
    template<typename T>
    void attach(T* tptr, void (T::*mptr)(void), double d) {  
        if((mptr != NULL) && (tptr != NULL)) {
            counter = reload = (uint32_t)( d * 1000.0 );
            callback.attach(tptr, mptr);         
        }        
    }
};

// Mimic Mbed's Ticker class but using TIMER1 
// (note, only goes to milliseconds level not microseconds!)

class Ticker1Sys;
extern Ticker1Sys _ticker1Sys;

class Ticker1 {
protected:
    FunctionPointer callback;
    uint32_t counter;
    uint32_t reload;
public:
    Ticker1();
    ~Ticker1();
    void tick(void);
    
    void detach(void) {        
        callback.attach();
    }
    void attach(void (*fptr)(void), double d) {
        counter = reload = (uint32_t)( d * 1000.0 );
        callback.attach(fptr);
    }
    template<typename T>
    void attach(T* tptr, void (T::*mptr)(void), double d) {  
        if((mptr != NULL) && (tptr != NULL)) {
            counter = reload = (uint32_t)( d * 1000.0 );
            callback.attach(tptr, mptr);         
        }        
    }
};

// Mimic Mbed's Ticker class but using TIMER2
// (note, only goes to milliseconds level not microseconds!)

class Ticker2Sys;
extern Ticker2Sys _ticker2Sys;

class Ticker2 {
protected:
    FunctionPointer callback;
    uint32_t counter;
    uint32_t reload;
public:
    Ticker2();
    ~Ticker2();
    void tick(void);
    
    void detach(void) {        
        callback.attach();
    }
    void attach(void (*fptr)(void), double d) {
        counter = reload = (uint32_t)( d * 1000.0 );
        callback.attach(fptr);
    }
    template<typename T>
    void attach(T* tptr, void (T::*mptr)(void), double d) {  
        if((mptr != NULL) && (tptr != NULL)) {
            counter = reload = (uint32_t)( d * 1000.0 );
            callback.attach(tptr, mptr);         
        }        
    }
};

// Mimic Mbed's Ticker class but using RIT
// (note, only goes to milliseconds level not microseconds!)

class TickerRSys;
extern TickerRSys _tickerRSys;

class Ticker4 {
protected:
    FunctionPointer callback;
    uint32_t counter;
    uint32_t reload;
public:
    Ticker4();
    ~Ticker4();
    void tick(void);
    
    void detach(void) {        
        callback.attach();
    }
    void attach(void (*fptr)(void), double d) {
        counter = reload = (uint32_t)( d * 1000.0 );
        callback.attach(fptr);
    }
    template<typename T>
    void attach(T* tptr, void (T::*mptr)(void), double d) {  
        if((mptr != NULL) && (tptr != NULL)) {
            counter = reload = (uint32_t)( d * 1000.0 );
            callback.attach(tptr, mptr);         
        }        
    }
};

// Mimic Mbed's Ticker class but using actual Ticker by inheriting.
// This just basically "renames" Ticker to TickerE for consistancy.

class Ticker3 : public Ticker {
public:
    Ticker3() : Ticker() {};
};

}; // namespace AjK ends.

#endif
