/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

// Mimic Mbed's Ticker class but using TIMER2
// (note, only goes to milliseconds level not microseconds!)

#include "TickersSys.h"

namespace AjK {

// Create a Ticker1 controller.
Ticker2Sys _ticker2Sys;

// Nice and simple ISR, just call the class standard handler.
extern "C" void TIMER2_IRQHandler(void) __irq 
{
    _ticker2Sys.isr();    
}

Ticker2Sys::Ticker2Sys(void)
{    
    LPC_SC->PCONP    |= (1UL << 22); // TIM1 On
    LPC_SC->PCLKSEL1 |= (3UL << 12); // CCLK/8 = 12MHz
    LPC_TIM2->PR      = 11;          // TC clocks at 1MHz.
    LPC_TIM2->MR0     = 1000;        // Match at 1kHz.
    LPC_TIM2->MCR    |= 1;           // Generate an interrupt.
    LPC_TIM2->TCR     = 1;           // Enable Timer1 to count.
    NVIC_EnableIRQ(TIMER2_IRQn);
}

void 
Ticker2Sys::addTicker(Ticker2 *t)
{
    tickers.push_back(t);   
}

void 
Ticker2Sys::delTicker(Ticker2 *t)
{
    for (list<Ticker2 *>::iterator itor = tickers.begin(); itor !=  tickers.end(); ++itor) {
        if ((*itor) == t) {
            itor = tickers.erase(itor);
            return;
        }
    }
}

void 
Ticker2Sys::isr(void)
{
    LPC_TIM2->IR = 1;
    LPC_TIM2->MR0 += 1000;
    if (tickers.empty()) return;
    
    for (list<Ticker2 *>::iterator itor = tickers.begin(); itor !=  tickers.end(); ++itor) {
        (*itor)->tick();
    }
    
}    

}; // namespace AjK ends.


