/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

// Mimic Mbed's Ticker class but using TIMER1 
// (note, only goes to milliseconds level not microseconds!)

#include "TickersSys.h"

namespace AjK {

// Create a Ticker1 controller.
Ticker1Sys _ticker1Sys;

// Nice and simple ISR, just call the class standard handler.
extern "C" void TIMER1_IRQHandler(void) __irq 
{
    _ticker1Sys.isr();    
}

Ticker1Sys::Ticker1Sys(void)
{    
    LPC_SC->PCONP    |= (1UL << 2); // TIM1 On
    LPC_SC->PCLKSEL0 |= (3UL << 4); // CCLK/8 = 12MHz
    LPC_TIM1->PR      = 11;         // TC clocks at 1MHz.
    LPC_TIM1->MR0     = 1000;       // Match at 1kHz.
    LPC_TIM1->MCR    |= 1;          // Generate an interrupt.
    LPC_TIM1->TCR     = 1;          // Enable Timer1 to count.
    NVIC_EnableIRQ(TIMER1_IRQn);
}

void 
Ticker1Sys::addTicker(Ticker1 *t)
{
    tickers.push_back(t);   
}

void 
Ticker1Sys::delTicker(Ticker1 *t)
{
    for (list<Ticker1 *>::iterator itor = tickers.begin(); itor !=  tickers.end(); ++itor) {
        if ((*itor) == t) {
            itor = tickers.erase(itor);
            return;
        }
    }
}

void 
Ticker1Sys::isr(void)
{
    LPC_TIM1->IR = 1;
    LPC_TIM1->MR0 += 1000;
    if (tickers.empty()) return;
    
    for (list<Ticker1 *>::iterator itor = tickers.begin(); itor !=  tickers.end(); ++itor) {
        (*itor)->tick();
    }
    
}    
}; // namespace AjK ends.
