
#include "mbed.h"
#include "SimpleTLE5206Profiler.h"

/* See example1.h for basic notes.
 *
 * This example shows how to use the acceleration and deceleration
 * profiler to manage changing speed in a simple linear fashion.
 *
 * The default accel and decel rates are 0.01/10ms. So when a speed
 * of say +1.0 is demanded, it actually takes 1second to reach that
 * target desired speed due to the acceleration profiler. Likewise
 * for deceleration.
 *
 * You can adjust the rates by altering the "poll interval" and the
 * accel/decel rates with the API functions.
 */

#define DUTY_CYCLE_IN_HERTZ 50

// Create a motor "A", driven by a TLE5206 on pins 21 and 22 (attach scope first, not a motor!)
SimpleTLE5206Output Ain1(p21);    // TLE5206 In1 is connected to p21
SimpleTLE5206Output Ain2(p22);    // TLE5206 In2 is connected to p22
SimpleTLE5206Profiler motorA(&Ain1, &Ain2, DUTY_CYCLE_IN_HERTZ); // Create the TLE5206 controller.

int main() {

    while(1) {    
        // Start from stationary.
        motorA.setSpeed(0);
        wait(1);
        
        // Command full desired speed CW
        motorA.setSpeed(1.0);
        
        // Wait for it to reach that speed.
        while( motorA.getSpeed() != 1.0) ;
        
        // Wait for 3seconds
        wait(3);
        
        // Stop the motor
        motorA.setSpeed(0.0);
        while( motorA.getSpeed() != 0.0) ;   
        
        // Wait for 3seconds
        wait(3);
        
        // Command full desired speed CCW
        motorA.setSpeed(-1.0);
        
        // Wait for it to reach that speed.
        while( motorA.getSpeed() != -1.0) ;
        
        // Wait for 3seconds
        wait(3);
        
        // Stop the motor
        motorA.setSpeed(0.0);
        while( motorA.getSpeed() != 0.0) ;   
        
        // Wait for 3seconds
        wait(3);

        // repeat the cycle.        
    }
}


