/*
    Copyright (c) 2011 Andy Kirkham
    
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

/*
    See http://mbed.org/forum/mbed/topic/2463/
*/

#ifndef AJK_SIMPLETLE5206_H
#define AJK_SIMPLETLE5206_H

#include "LPC17xx.h"
#include "SimpleTLE5206Output.h"

namespace AjK {

class SimpleTLE5206 {

public:
    enum PwmCh { NoPwm0, Pwm1, Pwm2, Pwm3, Pwm4, Pwm5, Pwm6, NumOfPwms  };

protected:
    uint32_t _duty;
    
    SimpleTLE5206Output *_in1;
    SimpleTLE5206Output *_in2;
    
    void setDuty(uint32_t u);
    
    void setMRx(PwmCh ch, uint32_t value);
    
    void init(uint32_t);
    
public:

    SimpleTLE5206() { error("We require two pins!\n"); }
        
    SimpleTLE5206(SimpleTLE5206Output *in1, SimpleTLE5206Output *in2, int duty_cycle_hz);

    SimpleTLE5206(SimpleTLE5206Output *in1, SimpleTLE5206Output *in2);
    
    void setSpeed(double d);
    
}; /* class SimpleTLE5206 ends. */

}; /* namespace AjK ends. */

using namespace AjK;

#endif
