
#include "mbed.h"
#include "SimpleSteppers.h"

SimpleStepperOutput led1(LED1);

// SimpleStepperOutput is basically the same as
// Mbed's DigitalOut class. However, it's more
// portable to other platforms without having
// to also port the entire Mbed library.
SimpleStepperOutput sdir0(p17);
SimpleStepperOutput sdir1(p18);
SimpleStepperOutput sdir2(p19);
SimpleStepperOutput sdir3(p20);

// Create four steppers.
// Stepper0 has the pulse output on p8 and dir on p17
SimpleStepper stepper0(p8, &sdir0);
// Stepper1 has the pulse output on p7 and dir on p18
SimpleStepper stepper1(p7, &sdir1);
// Stepper2 has the pulse output on p7 and dir on p19
SimpleStepper stepper2(p6, &sdir2);
// Stepper3 has the pulse output on p7 and dir on p20
SimpleStepper stepper3(p5, &sdir3);

int main() {

    // We do not need to maintain the stepper position
    // for this simple example. This reduces the amount
    // of work the ISR has to do.
    stepper0.setMaintainPositionData(false);
    stepper1.setMaintainPositionData(false);
    stepper2.setMaintainPositionData(false);
    stepper3.setMaintainPositionData(false);
    
    // Set all steppers to top speed of 5000 pulses/second.
    stepper0.setSpeed(5000);
    stepper1.setSpeed(5000);
    stepper2.setSpeed(5000);
    stepper3.setSpeed(5000);

    while(1) {
        led1 = !led1;
        wait(0.2);        
    }
}
